% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/zscoreParam.R
\docType{class}
\name{zscoreParam-class}
\alias{zscoreParam-class}
\alias{zscoreParam}
\title{\code{zscoreParam} class}
\usage{
zscoreParam(
  exprData,
  geneSets,
  assay = NA_character_,
  annotation = NULL,
  minSize = 1,
  maxSize = Inf
)
}
\arguments{
\item{exprData}{The expression data set.  Must be one of the classes
supported by \code{\linkS4class{GsvaExprData}}.  For a list of these classes, see its
help page using \code{help(GsvaExprData)}.}

\item{geneSets}{The gene sets.  Must be one of the classes supported by
\code{\linkS4class{GsvaGeneSets}}.  For a list of these classes, see its help page using
\code{help(GsvaGeneSets)}.}

\item{assay}{Character vector of length 1.  The name of the assay to use in
case \code{exprData} is a multi-assay container, otherwise ignored.  By default,
an assay called 'logcounts' will be used if present, otherwise the first
assay is used.}

\item{annotation}{An object of class \code{GeneIdentifierType} from
package \code{GSEABase} describing the gene identifiers used as the row names of
the expression data set.  See \code{GeneIdentifierType} for help on available
gene identifier types and how to construct them.  This
information can be used to map gene identifiers occurring in the gene sets.

If the default value \code{NULL} is provided, an attempt will be made to extract
the gene identifier type from the expression data set provided as \code{exprData}
(by calling \code{\link{gsvaAnnotation}} on it).  If still not successful, the
\code{NullIdentifier()} will be used as the gene identifier type, gene identifier
mapping will be disabled and gene identifiers used in expression data set and
gene sets can only be matched directly.}

\item{minSize}{Numeric vector of length 1.  Minimum size of the resulting gene
sets after gene identifier mapping. By default, the minimum size is 1.}

\item{maxSize}{Numeric vector of length 1.  Maximum size of the resulting gene
sets after gene identifier mapping. By default, the maximum size is \code{Inf}.}
}
\value{
A new \code{\linkS4class{zscoreParam}} object.
}
\description{
S4 class for combined z-scores method parameter objects.

Objects of class \code{zscoreParam} contain the parameters for
running the combined z-scores method.
}
\details{
Since the combined z-scores method does not take any method-specific
parameters, this class does not add any slots to the common slots inherited
from \code{GsvaMethodParam}.

The combined z-scores method takes a number of parameters shared
with all methods implemented by package GSVA but does not take any
method-specific parameters.
These parameters are described in detail below.
}
\examples{
library(GSVA)
suppressPackageStartupMessages(library(GSVAdata))

data(leukemia)
data(c2BroadSets)

## for simplicity, use only a subset of the sample data
ses <- leukemia_eset[1:1000, ]
gsc <- c2BroadSets[1:100]
zp1 <- zscoreParam(ses, gsc)
zp1


}
\references{
Lee, E. et al. Inferring pathway activity toward precise
disease classification.
\emph{PLoS Comp Biol}, 4(11):e1000217, 2008.
\doi{10.1371/journal.pcbi.1000217}
}
\seealso{
\code{\linkS4class{GsvaExprData}},
\code{\linkS4class{GsvaGeneSets}},
\code{\linkS4class{GsvaMethodParam}},
\code{\linkS4class{plageParam}},
\code{\linkS4class{ssgseaParam}},
\code{\linkS4class{gsvaParam}}

\code{\link[GSEABase:GeneIdentifierType-class]{GeneIdentifierType}}
}
