% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glPlotPosCtrlMEC.R
\name{glPlotPosCtrlMEC}
\alias{glPlotPosCtrlMEC}
\title{Box plot for positive control check}
\usage{
glPlotPosCtrlMEC(asid, masked=NULL)
}
\arguments{
\item{asid}{Assay source id}
\item{masked}{Masking color}
}
\value{
A list of ggplot objects, one per assay X timepoint.
}
\description{
This function plots positive controls for study id asid as well
as boxplot historical positive control MECs
}
\details{
This funtion is useful to select plates to mask
}
\note{
PMI-specific
}
\examples{
## Store the current config settings, so they can be reloaded at the end
## of the examples
conf_store <- gtoxConfList()
gtoxConfDefault()

## Create boxplot for all endpoints and chemicals tested. Useful to save
## plots in a pdf file.
pp <- glPlotPosCtrlMEC(asid = 1L)
pp[[1]]

## Reset configuration
options(conf_store)

}
