% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtoxPlotM4ID.R
\name{gtoxPlotM4ID}
\alias{gtoxPlotM4ID}
\title{Plot fit summary plot by m4id}
\usage{
gtoxPlotM4ID(m4id, lvl = 4L, bline = "bmad")
}
\arguments{
\item{m4id}{Integer, m4id(s) to plot}

\item{lvl}{Integer, the level of data to plot}

\item{bline}{Character of length 1, the value used for drawing the baseline
noise}
}
\value{
None
}
\description{
\code{gtoxPlotM4ID} creates a summary plots for the given m4id(s) by loading
the appropriate data from the gtox databases and sending it to
\code{\link{gtoxPlotFits}}
}
\details{
A level 4 plot ('lvl' = 4) will plot the concentration series and the
applicable curves, without an indication of the activity call or the
winning model. Level 4 plots can be created without having done subsequent
processing.

Level 5 plots include the level 4 information with the activity call and
model selection. The winning model will be highlighted red in the side panel
containing the summary statistics. Level 6 plots, in addition the all of the
level 4 and 5 information, include the positive flag IDs. If the flag has
an associated value, the value will be in parentheses follwing the flag ID.

Any values for 'bline' other than 'coff' will use 3*bmad.
}
\examples{
## Store the current config settings, so they can be reloaded at the end
## of the examples
conf_store <- gtoxConfList()
gtoxConfDefault()

acnm <- "Cytotoxicity (TIER1)_Cytochrome C release_24h"
pltnm <- "S-000049119"
myaid <- gtoxLoadApid()[u_boxtrack == pltnm, aid]
myaid <- myaid[myaid\%in\%gtoxLoadAid(fld = "asid", val = 1L)$aid]
apid <- gtoxLoadApid()[u_boxtrack == pltnm & aid == myaid, apid]
acid <- gtoxLoadAcid(fld = c("aid", "acnm"), val = list(myaid, acnm))[, acid]

aeid = gtoxLoadAeid(fld = c("acid", "analysis_direction"), 
  val = list(acid, "up"))[,aeid]
spid = gtoxLoadWaid(fld = c("apid", "wllt"), 
  val = list(apid, "c"))[,unique(spid)]
m4id = gtoxLoadData(lvl = 4L, fld = c("spid", "aeid"), 
  val = list(spid, aeid))[, m4id]

gtoxPlotM4ID(m4id = m4id, lvl = 6, bline = "coff") ## Create a level 4 plot
gtoxPlotM4ID(m4id = m4id, lvl = 5) ## Create a level 5 plot
gtoxPlotM4ID(m4id = m4id, lvl = 6) ## Create a level 6 plot

## Reset configuration
options(conf_store)

}
\seealso{
\code{\link{gtoxPlotFits}}, \code{\link{gtoxMakeAeidPlts}}
}
