% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnnotationDb_database.R
\name{AnnotationDb_database}
\alias{AnnotationDb_database}
\title{AnnotationDb database}
\usage{
AnnotationDb_database(source, table, ...)
}
\arguments{
\item{source}{(character) The name of an AnnotationDb package to
import the specified table from. Note the package should already be
installed.}

\item{table}{(character) The name of a table to import from the
specified source AnnotationDb package.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A \code{
AnnotationDb_database
} object. This object has no \code{output} slots.
}
\description{
Retrieve a table from an AnnotationDb package.
}
\details{
This object makes use of functionality from the following
packages:\itemize{ \item{\code{AnnotationDbi}}}
}
\section{Inheritance}{

A \code{AnnotationDb_database} object inherits the following \code{struct}
classes: \cr\cr
\verb{[AnnotationDb_database]} -> \verb{[annotation_database]} ->
\verb{[annotation_source]} -> \verb{[struct_class]}
}

\examples{
M <- AnnotationDb_database(
        table = character(0),
        tag = character(0),
        data = data.frame(),
        source = character(0))

}
\references{
Pagès H, Carlson M, Falcon S, Li N (2023).
\emph{AnnotationDbi: Manipulation of SQLite-based annotations in
Bioconductor}. doi:10.18129/B9.bioc.AnnotationDbi
\url{https://doi.org/10.18129/B9.bioc.AnnotationDbi}, R package version
1.64.1, \url{https://bioconductor.org/packages/AnnotationDbi}.
}
\seealso{
\link[AnnotationDbi:AnnotationDb-class]{AnnotationDbi::AnnotationDb}

Other annotation databases: 
\code{\link{GO_database}},
\code{\link{annotation_database}},
\code{\link{annotation_source}},
\code{\link{excel_database}},
\code{\link{rdata_database}},
\code{\link{rds_cache}},
\code{\link{rds_database}}
}
\concept{annotation databases}
