% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/go_database_class.R
\name{GO_database}
\alias{GO_database}
\title{GO.db}
\usage{
GO_database(source = "GO.db", table = "GOBPOFFSPRING", ...)
}
\arguments{
\item{source}{(character) The name of an AnnotationDb package to
import the specified table from. Note the package should already be
installed. The default is \code{"GO.db"}.}

\item{table}{(character) The name of a table to import from the GO.db
package. Allowed tables include:
GOBPANCESTOR,GOBPPARENTS,GOBPCHILDREN,GOBPOFFSPRING (and their CC or
MF equivalents), GOTERM, GOSYNONYM, GOOBSOLETE. The default is
\code{"GOBPOFFSPRING"}.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A \code{
GO_database
} object. This object has no \code{output} slots.
}
\description{
Retrieve a table from the Gene Ontology using the
\code{GO.db} package.
}
\details{
This object makes use of functionality from the following
packages:\itemize{ \item{\code{GO.db}}}
}
\section{Inheritance}{

A \code{GO_database} object inherits the following \code{struct} classes:
\cr\cr
\verb{[GO_database]} -> \verb{[AnnotationDb_database]} ->
\verb{[annotation_database]} -> \verb{[annotation_source]} -> \verb{[struct_class]}
}

\examples{
M <- GO_database(
        table = "GOBPCHILDREN",
        tag = character(0),
        data = data.frame(),
        source = character(0))

}
\references{
Carlson M (2023). \emph{GO.db: A set of annotation maps
describing the entire Gene Ontology}. R package version 3.18.0.

Pagès H, Carlson M, Falcon S, Li N (2023).
\emph{AnnotationDbi: Manipulation of SQLite-based annotations in
Bioconductor}. doi:10.18129/B9.bioc.AnnotationDbi
\url{https://doi.org/10.18129/B9.bioc.AnnotationDbi}, R package version
1.64.1, \url{https://bioconductor.org/packages/AnnotationDbi}.
}
\seealso{
\code{\link[GO.db:GOBASE]{GO.db::GO()}}

Other annotation databases: 
\code{\link{AnnotationDb_database}},
\code{\link{annotation_database}},
\code{\link{annotation_source}},
\code{\link{excel_database}},
\code{\link{rdata_database}},
\code{\link{rds_cache}},
\code{\link{rds_database}}
}
\concept{annotation databases}
