% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_columns_class.R
\name{remove_columns}
\alias{remove_columns}
\title{Select columns}
\usage{
remove_columns(expression = everything(), ...)
}
\arguments{
\item{expression}{(call) A valid rlang::expr for tidy evaluation via
eval_select. e.g.  \code{expression = all_of(c("foo","bar"))} will select
columns named "foo" and "bar" from the annotation data.frame.  . The
default is \code{everything()}.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A \code{remove_columns} object with the following
\code{output} slots:
\tabular{ll}{
\code{updated} \tab (annotation_source) The updated annotations as an
\code{annotation_source} object. \cr
}
}
\description{
A wrapper around \code{\link[tidyselect:eval_select]{tidyselect::eval_select}}. Remove
columns from an annotation table using tidy grammar.
}
\details{
This object makes use of functionality from the following
packages:\itemize{ \item{\code{tidyselect}} \item{\code{rlang}}}
}
\section{Inheritance}{

A \code{remove_columns} object inherits the following \code{struct} classes:
\cr\cr
\verb{[remove_columns]} -> \verb{[model]} -> \verb{[struct_class]}
}

\examples{
M <- remove_columns(
        expression = call("example"))

}
\references{
Henry L, Wickham H (2024). \emph{tidyselect: Select from a Set
of Strings}. R package version 1.2.1,
\url{https://CRAN.R-project.org/package=tidyselect}.

Henry L, Wickham H (2024). \emph{rlang: Functions for Base
Types and Core R and 'Tidyverse' Features}. R package version 1.1.3,
\url{https://CRAN.R-project.org/package=rlang}.
}
\seealso{
\code{\link[dplyr:select]{dplyr::select()}}

\code{\link[tidyselect:eval_select]{tidyselect::eval_select()}}
}
