% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bowtieCuda.R
\name{nvBWT}
\alias{nvBWT}
\title{nvBWT : builds the BWT indices of the reference FASTA files}
\usage{
nvBWT(myinput, output, options = NULL)
}
\arguments{
\item{myinput}{\code{Character} vector. A path to a .fa file}

\item{output}{\code{Character} vector. A path to a index file
used for the alignment output.}

\item{options}{\code{Character} vector. Options
Example: \code{--verbosity}}
}
\value{
An invisible \code{Integer} of call
status. The value is 0 when there is not any mistakes
Otherwise the value is non-zero.
}
\description{
This function can be use to call wrapped \code{nvBWT}
binary.
}
\details{
Available options:

\preformatted{
-v       | --verbosity     int (0-6) [5]     // select the verbosity level
-m       | --max-length    int       [inf]   // clamp input length
-b       | --byte-packing  [default]         // output a byte-encoded .pac file
-w       | --word-packing                    // output a word-encoded .wpac file
                                             // (more efficient)
-c       | --crc                             // compute CRCs
-d       | --device                          // select a cuda device
}
}
\examples{
td <- tempdir()
fa_file <- system.file(package='RbowtieCuda', 'extdata', 'bt2', 'refs', 'lambda_virus.fa')
nvBWT(myinput=fa_file, output=file.path(td, 'index'), options='')
}
\references{
Langmead, B., & Salzberg, S. L. (2012).
Fast gapped-read alignment with Bowtie 2. Nature methods, 9(4), 357-359.
}
\author{
Franck RICHARD
}
