% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{data}
\alias{data}
\alias{mockSC}
\alias{mockSP}
\alias{getMGS}
\title{Synthetic single-cell, mixture and marker data}
\usage{
mockSC(ng = 200, nc = 50, nt = 3)

mockSP(x, ns = 100)

getMGS(x, n_top = 10)
}
\arguments{
\item{ng, nc, nt, ns}{integer scalar specifying the number
of genes, cells, types (groups) and spots to simulate.}

\item{x}{Single cell experiment object}

\item{n_top}{integer specifying the number of
marker genes to extract for each cluster.}
}
\value{
\itemize{
\item{\code{mockSC} returns a \code{SingleCellExperiment}
  with rows = genes, columns = single cells, and cell metadata
  (\code{colData}) column \code{type} containing group identifiers.}
\item{\code{mockSP} returns a \code{SingleCellExperiment}
  with rows = genes, columns = single cells, and cell metadata
  (\code{colData}) column \code{type} containing group identifiers.}
\item{\code{getMGS} returns a \code{data.frame} with \code{nt*n_top}
  rows and 3 columns: gene and type (group) identifier, as well as the
  gene's weight = the proportion of counts accounted for by that type.}
}
}
\description{
\code{mockSC/mockSP()} are designed to generate synthetic single-cell and
spatial mixture data. These data are not meant to represent biologically
meaningful use-cases, but are solely intended for use in examples, for
unit-testing, and to demonstrate \code{SPOTlight}'s general functionality.
Finally, \code{.get_mgs()} implements a statistically naive way to select
markers from single-cell data; again, please don't use it in real life.
}
\examples{
sce <- mockSC()
spe <- mockSP(sce)
mgs <- getMGS(sce)
}
