% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knn.and.statistics.R
\name{SconeValues}
\alias{SconeValues}
\title{Master function for per-knn statistics functionality, integrating the
other non-exported functions within this script.}
\usage{
SconeValues(nn.matrix, cell.data, scone.markers, unstim, threshold = 0.05,
  fold = "median", stat.test = "mwu", multiple.donor.compare = FALSE)
}
\arguments{
\item{nn.matrix}{a matrix of cell index by nearest neighbor index, with
values being cell index of the nth nearest neighbor}

\item{cell.data}{tibble of cells by features}

\item{scone.markers}{vector of all markers to be interrogated via
statistical testing}

\item{unstim}{an object (used so far: string, number)
specifying the "basal" condition}

\item{threshold}{a number indicating the p value the raw change should
be thresholded by.}

\item{fold}{a string that specifies the use of "median" or "mean" when
calculating fold change}

\item{stat.test}{string denoting Mann Whitney U test ("mwu") or T test ("t)}

\item{multiple.donor.compare}{a boolean that indicates whether t test
across multiple donors should be done}
}
\value{
result: tibble of raw changes and p values for each feature of
interest, and fraction of cells with condition 2
}
\description{
This function is run following the KNN computation
and respective cell grouping. The function also contains a progress ticker
that allows one to determine how much time left in this function.
}
\examples{
ex.nn <- Fnn(wand.combined, input.markers)
SconeValues(ex.nn, wand.combined, funct.markers, "basal")
}
