% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.files.R
\name{SplitFile}
\alias{SplitFile}
\title{Runs "process.multiple.files" on a single file, splits it randomly,
and presends half of it is "unstim" and half of it is "stim"}
\usage{
SplitFile(file, transform = "asinh", numcells = 10000, norm = FALSE,
  scale = FALSE, input.markers)
}
\arguments{
\item{file}{the file we're going to split}

\item{transform}{if set to asinh, performs asinh transformation on all
markers of the dataset}

\item{numcells}{the number of total cells to be subsampled to, set at 10k
for default}

\item{norm}{boolean of whether data should be quantile normalized}

\item{scale}{boolean of whether data should be z-scored}

\item{input.markers}{vector of strings indicating the markers
to be used as input}
}
\value{
tibble containing original markers and all values
calculated by SCONE
}
\description{
This is meant to serve as a control for the basic "unstim"
and "stim" pipeline that is generally used within this package.
If phosphoproteins are being compared across conditions, for example,
then there should be no difference in the case that you split the same file
and compare the two halves.
}
\examples{
file <- system.file("extdata", "Bendall_et_al_Cell_Sample_C_basal.fcs",
    package = "Sconify")
SplitFile(file, input.markers = input.markers)
}
