% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createGeneAnnotation.R
\name{createGeneAnnotation}
\alias{createGeneAnnotation}
\title{Create gene annotation object}
\usage{
createGeneAnnotation(
  window,
  TxDb = TxDb.Hsapiens.UCSC.hg19.knownGene::TxDb.Hsapiens.UCSC.hg19.knownGene,
  longest = TRUE
)
}
\arguments{
\item{window}{\linkS4class{GRanges} object with coordinates to use for
selecting the genes to plot.}

\item{TxDb}{TxDb object to use for drawing the genomic annotation.}

\item{longest}{Logical indicating whether to plot only the longest
transcripts for each gene in the gene annotation plot.}
}
\value{
GRanges object with the gene annotation in the window.
}
\description{
Create gene annotation object
}
\examples{
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
window <- GRanges("chr16:11298262-11400036")
gene_anno <- createGeneAnnotation(
    window = window,
    TxDb = TxDb.Hsapiens.UCSC.hg19.knownGene
)
}
