% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contactsUMI4C.R
\name{.singleSplitUMI4C}
\alias{.singleSplitUMI4C}
\title{Split fastq files at a given restriction site.}
\usage{
.singleSplitUMI4C(
  fastq_file,
  res_enz,
  cut_pos,
  split_dir,
  min_flen = 20,
  numb_reads = 1e+09
)
}
\arguments{
\item{fastq_file}{Fastq file path.}

\item{res_enz}{Character containing the restriction enzyme sequence.}

\item{cut_pos}{Numeric indicating the nucleotide position where restriction
enzyme cuts (zero-based) (for example, for DpnII is 0).}

\item{split_dir}{Directory where to save split files.}

\item{min_flen}{Minimal fragment length to use for selecting the fragments.
Default=20}

\item{numb_reads}{Number of lines from the FastQ file to load in each loop.
If having memory size problems, change it to a smaller number. Default=1e9.}
}
\value{
Creates a compressed FASTQ file in \code{wk_dir/split} named
\code{basename(fastq)).fq.gz}, containing the split reads based on the
restriction enzyme used.
}
\description{
Split fastq files at a given restriction site.
}
