% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callInteractions.R
\name{getSignInteractions}
\alias{getSignInteractions}
\title{Get significant interactions from a GRangesList}
\usage{
getSignInteractions(gr_interactions)
}
\arguments{
\item{gr_interactions}{GRangesList outputed by \code{\link{callInteractions}}.}
}
\value{
\code{GRanges} object with a list of significantly interacting regions.
}
\description{
Retrieves all significant interactions from the output of 
\code{\link{callInteractions}}.
}
\examples{
data("ex_ciita_umi4c")
umi <- ex_ciita_umi4c
win_frags <- makeWindowFragments(umi, n_frags=8, sliding=1)

gr <- callInteractions(umi, ~condition, win_frags, padj_threshold = 0.01, zscore_threshold=2)
inter <- getSignInteractions(gr)
}
