% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotUMI4C.R
\name{plotDomainogram}
\alias{plotDomainogram}
\title{Plot domainogram}
\usage{
plotDomainogram(
  umi4c,
  dgram_function = "quotient",
  grouping = NULL,
  colors = NULL,
  xlim = NULL
)
}
\arguments{
\item{umi4c}{\linkS4class{UMI4C} object as generated by \code{\link{makeUMI4C}}.}

\item{dgram_function}{Function used for calculating the fold-change in the
domainogram plot, either "difference" or "quotient". Default: "quotient".}

\item{grouping}{Grouping used for the different samples. If none available or 
want to add new groupings, run \code{\link{addGrouping}}.}

\item{colors}{Named vector of colors to use for plotting for each group.}

\item{xlim}{Limits for the plot x axis (genomic coordinates).}
}
\value{
Produces the domainogram plot, summarizing the merged number of UMIs
at the different scales analyzed (y axis).
}
\description{
Plot domainogram
}
\examples{
data("ex_ciita_umi4c")
ex_ciita_umi4c <- addGrouping(ex_ciita_umi4c, grouping="condition")

plotDomainogram(ex_ciita_umi4c, grouping = "condition")
}
