% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DA_linda.R
\name{DA_linda}
\alias{DA_linda}
\title{DA_linda}
\usage{
DA_linda(
  object,
  assay_name = "counts",
  formula = NULL,
  contrast = NULL,
  is.winsor = TRUE,
  outlier.pct = 0.03,
  zero.handling = c("pseudo-count", "imputation"),
  pseudo.cnt = 0.5,
  alpha = 0.05,
  p.adj.method = "BH",
  verbose = TRUE
)
}
\arguments{
\item{object}{a phyloseq or TreeSummarizedExperiment object.}

\item{assay_name}{the name of the assay to extract from the 
TreeSummarizedExperiment object (default \code{assayName = "counts"}). Not 
used if the input object is a phyloseq.}

\item{formula}{Character. For example: formula = '~x1*x2+x3+(1|id)'. At least one fixed effect is required.}

\item{contrast}{character vector with exactly, three elements: a string 
indicating the name of factor whose levels are the conditions to be 
compared, the name of the level of interest, and the name of the other 
level.}

\item{is.winsor}{Boolean. If TRUE (default), the Winsorization process will be conducted for the OTU table.}

\item{outlier.pct}{A real value between 0 and 1; Winsorization cutoff (percentile) for the OTU table, e.g., 0.03. Default is NULL. If NULL, Winsorization process will not be conducted.}

\item{zero.handling}{Character. Specifies the method to handle zeros in the OTU table. Options are "pseudo-count" or "imputation" (default is "pseudo-count"). If "imputation", zeros in the OTU table will be imputed using the formula in the referenced paper. If "pseudo-count", a small constant (pseudo.cnt) will be added to each value in the OTU table.}

\item{pseudo.cnt}{A positive real value. Default is 0.5. If zero.handling is set to "pseudo-count", this constant will be added to each value in the OTU table.}

\item{alpha}{A real value between 0 and 1; significance level of differential abundance. Default is 0.05.}

\item{p.adj.method}{Character; p-value adjusting approach. See R function p.adjust. Default is 'BH'.}

\item{verbose}{an optional logical value. If \code{TRUE}, information about
the steps of the algorithm is printed. Default \code{verbose = TRUE}.}
}
\value{
A list object containing the matrix of p-values `pValMat`,
a matrix of summary statistics for each tag `statInfo`, and a suggested 
`name` of the final object considering the parameters passed to the 
function.
}
\description{
Fast run for linda differential abundance detection method.
}
\examples{
set.seed(1)
# Create a very simple phyloseq object
counts <- matrix(rnbinom(n = 60, size = 3, prob = 0.5), nrow = 10, ncol = 6)
metadata <- data.frame("Sample" = c("S1", "S2", "S3", "S4", "S5", "S6"),
                       "group" = as.factor(c("A", "A", "A", "B", "B", "B")))
ps <- phyloseq::phyloseq(phyloseq::otu_table(counts, taxa_are_rows = TRUE),
                         phyloseq::sample_data(metadata))
# Differential abundance
DA_linda(object = ps, formula = "~ group", contrast = c("group", "B", "A"), 
    is.winsor = TRUE, zero.handling = "pseudo-count", verbose = FALSE)
}
\seealso{
\code{\link[MicrobiomeStat]{linda}}.
}
