% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runNormalizations.R
\name{checkNormalization}
\alias{checkNormalization}
\title{checkNormalization}
\usage{
checkNormalization(fun, method, ...)
}
\arguments{
\item{fun}{a character with the name of normalization function (e.g.
"norm_edgeR", "norm_DESeq2", "norm_CSS"...).}

\item{method}{a character with the normalization method (e.g.
"TMM", "upperquartile"... if the \code{fun} is "norm_edgeR").}

\item{...}{other arguments if needed (e.g. for \code{\link{norm_edgeR}}
normalizations).}
}
\value{
a list object containing the normalization method and its
parameters.
}
\description{
Check if the normalization function's name and the method's name to compute
normalization/scaling factors are correctly matched.
}
\examples{
# Check if TMM normalization belong to "norm_edgeR"
check_TMM_normalization <- checkNormalization(fun = "norm_edgeR",
    method = "TMM")
}
\seealso{
\code{\link{setNormalizations}}, \code{\link{norm_edgeR}},
\code{\link{norm_DESeq2}}, \code{\link{norm_CSS}}, \code{\link{norm_TSS}}
}
