% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TIEC.R
\name{createMocks}
\alias{createMocks}
\title{createMocks}
\usage{
createMocks(nsamples, N = 1000)
}
\arguments{
\item{nsamples}{an integer representing the total number of samples.}

\item{N}{number of mock comparison to generate.}
}
\value{
a \code{data.frame} containing \code{N} rows and \code{nsamples}
columns (if even). Each cell of the data frame contains the "grp1" or "grp2"
characters which represent the mock groups pattern.
}
\description{
Given the number of samples of the dataset from which the mocks should be
created, this function produces a \code{data.frame} object with as many rows
as the number of mocks and as many columns as the number of samples. If an
odd number of samples is given, the lower even integer will be considered in
order to obtain a balanced design for the mocks.
}
\examples{
# Generate the pattern for 100 mock comparisons for an experiment with 30
# samples
mocks <- createMocks(nsamples = 30, N = 100)
head(mocks)
}
