% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norm_TSS.R
\name{norm_TSS}
\alias{norm_TSS}
\title{norm_TSS}
\usage{
norm_TSS(object, assay_name = "counts", method = "TSS", verbose = TRUE)
}
\arguments{
\item{object}{a phyloseq or TreeSummarizedExperiment object.}

\item{assay_name}{the name of the assay to extract from the 
TreeSummarizedExperiment object (default \code{assayName = "counts"}). Not 
used if the input object is a phyloseq.}

\item{method}{normalization method to be used.}

\item{verbose}{an optional logical value. If \code{TRUE}, information about
the steps of the algorithm is printed. Default \code{verbose = TRUE}.}
}
\value{
A new column containing the TSS scaling factors is added to the 
\code{sample_data} slot of the phyloseq object or the \code{colData} slot of 
the TreeSummarizedExperiment object.
}
\description{
Calculate the Total Sum Scaling (TSS) factors for a phyloseq or a 
TreeSummarizedExperiment object, i.e. the library sizes. If the counts are 
divided by the scaling factors, a relative abundance is obtained.
}
\examples{
set.seed(1)
# Create a very simple phyloseq object
counts <- matrix(rnbinom(n = 60, size = 3, prob = 0.5), nrow = 10, ncol = 6)
metadata <- data.frame("Sample" = c("S1", "S2", "S3", "S4", "S5", "S6"),
                       "group" = as.factor(c("A", "A", "A", "B", "B", "B")))
ps <- phyloseq::phyloseq(phyloseq::otu_table(counts, taxa_are_rows = TRUE),
                         phyloseq::sample_data(metadata))

# Calculate the scaling factors
ps_NF <- norm_TSS(object = ps)
# The phyloseq object now contains the scaling factors:
scaleFacts <- phyloseq::sample_data(ps_NF)[, "NF.TSS"]
head(scaleFacts)
}
\seealso{
\code{\link{setNormalizations}} and \code{\link{runNormalizations}}
to fastly set and run normalizations.
}
