% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TIEC.R
\name{runMocks}
\alias{runMocks}
\title{runMocks}
\usage{
runMocks(
  mocks,
  method_list,
  object,
  weights = NULL,
  verbose = TRUE,
  BPPARAM = BiocParallel::SerialParam()
)
}
\arguments{
\item{mocks}{a \code{data.frame} containing \code{N} rows and \code{nsamples}
columns (if even). Each cell of the data frame contains the "grp1" or "grp2"
characters which represent the mock groups pattern. Produced by the
\code{\link{createMocks}} function.}

\item{method_list}{a list object containing the methods and their parameters.}

\item{object}{a phyloseq or TreeSummarizedExperiment object.}

\item{weights}{an optional numeric matrix giving observational weights.}

\item{verbose}{an optional logical value. If \code{TRUE}, information about
the steps of the algorithm is printed. Default \code{verbose = TRUE}.}

\item{BPPARAM}{An optional \code{\link[BiocParallel]{BiocParallelParam}} instance
    defining the parallel back-end to be used during evaluation.
  }
}
\value{
A named list containing the results for each method.
}
\description{
Run the differential abundance detection methods on mock datasets.
}
\examples{
# Load some data
data(ps_stool_16S)

# Generate the pattern for 10 mock comparisons
# (N = 1000 is suggested)
mocks <- createMocks(nsamples = phyloseq::nsamples(ps_stool_16S), N = 10)
head(mocks)

# Add some normalization/scaling factors to the phyloseq object
my_norm <- setNormalizations(fun = c("norm_edgeR", "norm_CSS"),
    method = c("TMM", "CSS"))
ps_stool_16S <- runNormalizations(normalization_list = my_norm,
    object = ps_stool_16S)

# Initialize some limma based methods
my_limma <- set_limma(design = ~ group, coef = 2, norm = c("TMM", "CSS"))

# Run methods on mock datasets
results <- runMocks(mocks = mocks, method_list = my_limma,
    object = ps_stool_16S)
}
