% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AUC_DM_analysis.R
\name{AUC_DM_analysis}
\alias{AUC_DM_analysis}
\title{Area under the curve method for calculating dissimilarities between
estimated distributions}
\usage{
AUC_DM_analysis(M, N, R, K, tau, A, phi)
}
\arguments{
\item{M}{Number of methylation states to be identified in a single DNA
sample.}

\item{N}{Number of patients or DNA sample replicates collected for each
treatment group.}

\item{R}{Number of treatment groups (For. eg: Benign and Tumour).}

\item{K}{Number of hidden states estimated.}

\item{tau}{The initial distribution for hidden states in the betaHMM model.}

\item{A}{The transition matrix for hidden states in the betaHMM model.}

\item{phi}{The shape parameters estimated for the observed data and the
estimated hidden states in the betaHMM model.}
}
\value{
A dataframe returning the hidden state, the AUC value and the
distributions which resulted in highest AUC value calculated
for the corresponding hidden state.
}
\description{
The function is used to calculate the dissimilarity between the
cumulative distributions estimated in each hidden state.
}
\keyword{internal}
