% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/summary-functions.R
\name{summary}
\alias{summary}
\alias{summary,betaHMMResults-method}
\alias{summary-methods}
\alias{summary,dmcResults-method}
\alias{summary,dmrResults-method}
\title{Summarize results from the three betaHMM workflow functions}
\usage{
summary(object, ...)

\S4method{summary}{betaHMMResults}(object, ...)

\S4method{summary}{dmcResults}(object, ...)

\S4method{summary}{dmrResults}(object, ...)
}
\arguments{
\item{object}{An object of class \code{'betaHMMResults'} or
\code{'dmcResults'} or \code{'dmrResults'}.}

\item{...}{Additional arguments}
}
\value{
Summary of the \code{'betaHMMResults'} or
\code{'dmcResults'} or \code{'dmrResults'} object.
}
\description{
A function to summarize the \code{betaHMMResults}, \code{dmcResults} or
\code{dmrResults} objects.
}
\examples{
## Use simulated data for the betaHMM workflow example
set.seed(12345)

## read files
data(sample_methylation_file)
data(sample_annotation_file)
# Run betaHMM function
beta_out <- betaHMM(sample_methylation_file[1:50,],
                    sample_annotation_file[1:50,],
                    M = 3, N = 4, R = 2,iterations=2,
                    parallel_process = FALSE, seed = 12345,
                    treatment_group = c("Benign","Tumour"))

## Run dmc_identification function
dmc_out <- dmc_identification(beta_out)

# Run dmr_identification function
dmr_out <- dmr_identification(dmc_out, parallel_process = FALSE)

# Plot functions
# Get the AUC values calculated for each hidden state
AUC_chr <- AUC(dmc_out)

## plot the uncertainty for each hidden state
plot(beta_out, chromosome = "1", what = "uncertainty")

}
\seealso{
\code{\link{betaHMM}}, \code{\link{dmc_identification}},
\code{\link{dmr_identification}}
}
\author{
Koyel majumdar
}
\keyword{methods}
