% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiodbConn.R
\name{BiodbConn}
\alias{BiodbConn}
\title{The mother abstract class of all database connectors.}
\description{
The mother abstract class of all database connectors.

The mother abstract class of all database connectors.
}
\details{
This is the super class of all connector classes. All methods defined here
are thus common to all connector classes. All connector classes inherit
from this abstract class.

See section Fields for a list of the constructor's
parameters. Concrete classes may have direct web services methods or other
specific methods implemented, in which case they will be described inside the
documentation of the concrete class. Please refer to the documentation of
each concrete class for more information. The database direct web services
methods will be named "ws.*".

The constructor has the following arguments:

id: The identifier of the connector.

cache.id: The identifier used in the disk cache.
}
\examples{
# Create an instance with default settings:
mybiodb <- biodb::newInst()

# Get a compound CSV file database
chebi.tsv <- system.file("extdata", "chebi_extract.tsv", package='biodb')

# Create a connector
conn <- mybiodb$getFactory()$createConn('comp.csv.file', url=chebi.tsv)

# Get 10 identifiers from the database:
ids <- conn$getEntryIds(10)

# Get number of entries contained in the database:
n <- conn$getNbEntries()

# Terminate instance.
mybiodb$terminate()

}
\seealso{
Super class \code{\link{BiodbConnBase}}, and
\code{\link{BiodbFactory}} class.
}
\section{Super class}{
\code{\link[biodb:BiodbConnBase]{biodb::BiodbConnBase}} -> \code{BiodbConn}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-BiodbConn-new}{\code{BiodbConn$new()}}
\item \href{#method-BiodbConn-getBiodb}{\code{BiodbConn$getBiodb()}}
\item \href{#method-BiodbConn-getId}{\code{BiodbConn$getId()}}
\item \href{#method-BiodbConn-print}{\code{BiodbConn$print()}}
\item \href{#method-BiodbConn-correctIds}{\code{BiodbConn$correctIds()}}
\item \href{#method-BiodbConn-getEntry}{\code{BiodbConn$getEntry()}}
\item \href{#method-BiodbConn-getCacheFile}{\code{BiodbConn$getCacheFile()}}
\item \href{#method-BiodbConn-getEntryContent}{\code{BiodbConn$getEntryContent()}}
\item \href{#method-BiodbConn-getEntryContentFromDb}{\code{BiodbConn$getEntryContentFromDb()}}
\item \href{#method-BiodbConn-getEntryContentRequest}{\code{BiodbConn$getEntryContentRequest()}}
\item \href{#method-BiodbConn-getEntryIds}{\code{BiodbConn$getEntryIds()}}
\item \href{#method-BiodbConn-getNbEntries}{\code{BiodbConn$getNbEntries()}}
\item \href{#method-BiodbConn-isEditable}{\code{BiodbConn$isEditable()}}
\item \href{#method-BiodbConn-editingIsAllowed}{\code{BiodbConn$editingIsAllowed()}}
\item \href{#method-BiodbConn-allowEditing}{\code{BiodbConn$allowEditing()}}
\item \href{#method-BiodbConn-disallowEditing}{\code{BiodbConn$disallowEditing()}}
\item \href{#method-BiodbConn-setEditingAllowed}{\code{BiodbConn$setEditingAllowed()}}
\item \href{#method-BiodbConn-addNewEntry}{\code{BiodbConn$addNewEntry()}}
\item \href{#method-BiodbConn-isWritable}{\code{BiodbConn$isWritable()}}
\item \href{#method-BiodbConn-allowWriting}{\code{BiodbConn$allowWriting()}}
\item \href{#method-BiodbConn-disallowWriting}{\code{BiodbConn$disallowWriting()}}
\item \href{#method-BiodbConn-setWritingAllowed}{\code{BiodbConn$setWritingAllowed()}}
\item \href{#method-BiodbConn-writingIsAllowed}{\code{BiodbConn$writingIsAllowed()}}
\item \href{#method-BiodbConn-write}{\code{BiodbConn$write()}}
\item \href{#method-BiodbConn-isSearchableByField}{\code{BiodbConn$isSearchableByField()}}
\item \href{#method-BiodbConn-getSearchableFields}{\code{BiodbConn$getSearchableFields()}}
\item \href{#method-BiodbConn-searchForEntries}{\code{BiodbConn$searchForEntries()}}
\item \href{#method-BiodbConn-searchByName}{\code{BiodbConn$searchByName()}}
\item \href{#method-BiodbConn-isDownloadable}{\code{BiodbConn$isDownloadable()}}
\item \href{#method-BiodbConn-isDownloaded}{\code{BiodbConn$isDownloaded()}}
\item \href{#method-BiodbConn-requiresDownload}{\code{BiodbConn$requiresDownload()}}
\item \href{#method-BiodbConn-getDownloadPath}{\code{BiodbConn$getDownloadPath()}}
\item \href{#method-BiodbConn-setDownloadedFile}{\code{BiodbConn$setDownloadedFile()}}
\item \href{#method-BiodbConn-isExtracted}{\code{BiodbConn$isExtracted()}}
\item \href{#method-BiodbConn-download}{\code{BiodbConn$download()}}
\item \href{#method-BiodbConn-isRemotedb}{\code{BiodbConn$isRemotedb()}}
\item \href{#method-BiodbConn-isCompounddb}{\code{BiodbConn$isCompounddb()}}
\item \href{#method-BiodbConn-searchCompound}{\code{BiodbConn$searchCompound()}}
\item \href{#method-BiodbConn-annotateMzValues}{\code{BiodbConn$annotateMzValues()}}
\item \href{#method-BiodbConn-isMassdb}{\code{BiodbConn$isMassdb()}}
\item \href{#method-BiodbConn-checkDb}{\code{BiodbConn$checkDb()}}
\item \href{#method-BiodbConn-getAllVolatileCacheEntries}{\code{BiodbConn$getAllVolatileCacheEntries()}}
\item \href{#method-BiodbConn-getAllCacheEntries}{\code{BiodbConn$getAllCacheEntries()}}
\item \href{#method-BiodbConn-deleteAllEntriesFromVolatileCache}{\code{BiodbConn$deleteAllEntriesFromVolatileCache()}}
\item \href{#method-BiodbConn-deleteAllEntriesFromPersistentCache}{\code{BiodbConn$deleteAllEntriesFromPersistentCache()}}
\item \href{#method-BiodbConn-deleteWholePersistentCache}{\code{BiodbConn$deleteWholePersistentCache()}}
\item \href{#method-BiodbConn-deleteAllCacheEntries}{\code{BiodbConn$deleteAllCacheEntries()}}
\item \href{#method-BiodbConn-getCacheId}{\code{BiodbConn$getCacheId()}}
\item \href{#method-BiodbConn-makesRefToEntry}{\code{BiodbConn$makesRefToEntry()}}
\item \href{#method-BiodbConn-makeRequest}{\code{BiodbConn$makeRequest()}}
\item \href{#method-BiodbConn-getEntryImageUrl}{\code{BiodbConn$getEntryImageUrl()}}
\item \href{#method-BiodbConn-getEntryPageUrl}{\code{BiodbConn$getEntryPageUrl()}}
\item \href{#method-BiodbConn-getChromCol}{\code{BiodbConn$getChromCol()}}
\item \href{#method-BiodbConn-getMatchingMzField}{\code{BiodbConn$getMatchingMzField()}}
\item \href{#method-BiodbConn-setMatchingMzField}{\code{BiodbConn$setMatchingMzField()}}
\item \href{#method-BiodbConn-getMzValues}{\code{BiodbConn$getMzValues()}}
\item \href{#method-BiodbConn-getNbPeaks}{\code{BiodbConn$getNbPeaks()}}
\item \href{#method-BiodbConn-filterEntriesOnRt}{\code{BiodbConn$filterEntriesOnRt()}}
\item \href{#method-BiodbConn-searchForMassSpectra}{\code{BiodbConn$searchForMassSpectra()}}
\item \href{#method-BiodbConn-searchMsEntries}{\code{BiodbConn$searchMsEntries()}}
\item \href{#method-BiodbConn-searchMsPeaks}{\code{BiodbConn$searchMsPeaks()}}
\item \href{#method-BiodbConn-msmsSearch}{\code{BiodbConn$msmsSearch()}}
\item \href{#method-BiodbConn-collapseResultsDataFrame}{\code{BiodbConn$collapseResultsDataFrame()}}
\item \href{#method-BiodbConn-searchMzRange}{\code{BiodbConn$searchMzRange()}}
\item \href{#method-BiodbConn-searchMzTol}{\code{BiodbConn$searchMzTol()}}
\item \href{#method-BiodbConn-clone}{\code{BiodbConn$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="biodb" data-topic="BiodbConnBase" data-id="getBaseUrl"><a href='../../biodb/html/BiodbConnBase.html#method-BiodbConnBase-getBaseUrl'><code>biodb::BiodbConnBase$getBaseUrl()</code></a></span></li>
<li><span class="pkg-link" data-pkg="biodb" data-topic="BiodbConnBase" data-id="getConnClass"><a href='../../biodb/html/BiodbConnBase.html#method-BiodbConnBase-getConnClass'><code>biodb::BiodbConnBase$getConnClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="biodb" data-topic="BiodbConnBase" data-id="getConnClassName"><a href='../../biodb/html/BiodbConnBase.html#method-BiodbConnBase-getConnClassName'><code>biodb::BiodbConnBase$getConnClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="biodb" data-topic="BiodbConnBase" data-id="getDbClass"><a href='../../biodb/html/BiodbConnBase.html#method-BiodbConnBase-getDbClass'><code>biodb::BiodbConnBase$getDbClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="biodb" data-topic="BiodbConnBase" data-id="getEntryClass"><a href='../../biodb/html/BiodbConnBase.html#method-BiodbConnBase-getEntryClass'><code>biodb::BiodbConnBase$getEntryClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="biodb" data-topic="BiodbConnBase" data-id="getEntryClassName"><a href='../../biodb/html/BiodbConnBase.html#method-BiodbConnBase-getEntryClassName'><code>biodb::BiodbConnBase$getEntryClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="biodb" data-topic="BiodbConnBase" data-id="getEntryContentType"><a href='../../biodb/html/BiodbConnBase.html#method-BiodbConnBase-getEntryContentType'><code>biodb::BiodbConnBase$getEntryContentType()</code></a></span></li>
<li><span class="pkg-link" data-pkg="biodb" data-topic="BiodbConnBase" data-id="getEntryFileExt"><a href='../../biodb/html/BiodbConnBase.html#method-BiodbConnBase-getEntryFileExt'><code>biodb::BiodbConnBase$getEntryFileExt()</code></a></span></li>
<li><span class="pkg-link" data-pkg="biodb" data-topic="BiodbConnBase" data-id="getEntryIdField"><a href='../../biodb/html/BiodbConnBase.html#method-BiodbConnBase-getEntryIdField'><code>biodb::BiodbConnBase$getEntryIdField()</code></a></span></li>
<li><span class="pkg-link" data-pkg="biodb" data-topic="BiodbConnBase" data-id="getName"><a href='../../biodb/html/BiodbConnBase.html#method-BiodbConnBase-getName'><code>biodb::BiodbConnBase$getName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="biodb" data-topic="BiodbConnBase" data-id="getPropSlots"><a href='../../biodb/html/BiodbConnBase.html#method-BiodbConnBase-getPropSlots'><code>biodb::BiodbConnBase$getPropSlots()</code></a></span></li>
<li><span class="pkg-link" data-pkg="biodb" data-topic="BiodbConnBase" data-id="getPropValSlot"><a href='../../biodb/html/BiodbConnBase.html#method-BiodbConnBase-getPropValSlot'><code>biodb::BiodbConnBase$getPropValSlot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="biodb" data-topic="BiodbConnBase" data-id="getPropertyValue"><a href='../../biodb/html/BiodbConnBase.html#method-BiodbConnBase-getPropertyValue'><code>biodb::BiodbConnBase$getPropertyValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="biodb" data-topic="BiodbConnBase" data-id="getSchedulerNParam"><a href='../../biodb/html/BiodbConnBase.html#method-BiodbConnBase-getSchedulerNParam'><code>biodb::BiodbConnBase$getSchedulerNParam()</code></a></span></li>
<li><span class="pkg-link" data-pkg="biodb" data-topic="BiodbConnBase" data-id="getSchedulerTParam"><a href='../../biodb/html/BiodbConnBase.html#method-BiodbConnBase-getSchedulerTParam'><code>biodb::BiodbConnBase$getSchedulerTParam()</code></a></span></li>
<li><span class="pkg-link" data-pkg="biodb" data-topic="BiodbConnBase" data-id="getToken"><a href='../../biodb/html/BiodbConnBase.html#method-BiodbConnBase-getToken'><code>biodb::BiodbConnBase$getToken()</code></a></span></li>
<li><span class="pkg-link" data-pkg="biodb" data-topic="BiodbConnBase" data-id="getUrl"><a href='../../biodb/html/BiodbConnBase.html#method-BiodbConnBase-getUrl'><code>biodb::BiodbConnBase$getUrl()</code></a></span></li>
<li><span class="pkg-link" data-pkg="biodb" data-topic="BiodbConnBase" data-id="getUrls"><a href='../../biodb/html/BiodbConnBase.html#method-BiodbConnBase-getUrls'><code>biodb::BiodbConnBase$getUrls()</code></a></span></li>
<li><span class="pkg-link" data-pkg="biodb" data-topic="BiodbConnBase" data-id="getWsUrl"><a href='../../biodb/html/BiodbConnBase.html#method-BiodbConnBase-getWsUrl'><code>biodb::BiodbConnBase$getWsUrl()</code></a></span></li>
<li><span class="pkg-link" data-pkg="biodb" data-topic="BiodbConnBase" data-id="getXmlNs"><a href='../../biodb/html/BiodbConnBase.html#method-BiodbConnBase-getXmlNs'><code>biodb::BiodbConnBase$getXmlNs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="biodb" data-topic="BiodbConnBase" data-id="hasProp"><a href='../../biodb/html/BiodbConnBase.html#method-BiodbConnBase-hasProp'><code>biodb::BiodbConnBase$hasProp()</code></a></span></li>
<li><span class="pkg-link" data-pkg="biodb" data-topic="BiodbConnBase" data-id="hasPropSlot"><a href='../../biodb/html/BiodbConnBase.html#method-BiodbConnBase-hasPropSlot'><code>biodb::BiodbConnBase$hasPropSlot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="biodb" data-topic="BiodbConnBase" data-id="isSlotProp"><a href='../../biodb/html/BiodbConnBase.html#method-BiodbConnBase-isSlotProp'><code>biodb::BiodbConnBase$isSlotProp()</code></a></span></li>
<li><span class="pkg-link" data-pkg="biodb" data-topic="BiodbConnBase" data-id="propExists"><a href='../../biodb/html/BiodbConnBase.html#method-BiodbConnBase-propExists'><code>biodb::BiodbConnBase$propExists()</code></a></span></li>
<li><span class="pkg-link" data-pkg="biodb" data-topic="BiodbConnBase" data-id="setBaseUrl"><a href='../../biodb/html/BiodbConnBase.html#method-BiodbConnBase-setBaseUrl'><code>biodb::BiodbConnBase$setBaseUrl()</code></a></span></li>
<li><span class="pkg-link" data-pkg="biodb" data-topic="BiodbConnBase" data-id="setPropValSlot"><a href='../../biodb/html/BiodbConnBase.html#method-BiodbConnBase-setPropValSlot'><code>biodb::BiodbConnBase$setPropValSlot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="biodb" data-topic="BiodbConnBase" data-id="setPropertyValue"><a href='../../biodb/html/BiodbConnBase.html#method-BiodbConnBase-setPropertyValue'><code>biodb::BiodbConnBase$setPropertyValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="biodb" data-topic="BiodbConnBase" data-id="setSchedulerNParam"><a href='../../biodb/html/BiodbConnBase.html#method-BiodbConnBase-setSchedulerNParam'><code>biodb::BiodbConnBase$setSchedulerNParam()</code></a></span></li>
<li><span class="pkg-link" data-pkg="biodb" data-topic="BiodbConnBase" data-id="setSchedulerTParam"><a href='../../biodb/html/BiodbConnBase.html#method-BiodbConnBase-setSchedulerTParam'><code>biodb::BiodbConnBase$setSchedulerTParam()</code></a></span></li>
<li><span class="pkg-link" data-pkg="biodb" data-topic="BiodbConnBase" data-id="setToken"><a href='../../biodb/html/BiodbConnBase.html#method-BiodbConnBase-setToken'><code>biodb::BiodbConnBase$setToken()</code></a></span></li>
<li><span class="pkg-link" data-pkg="biodb" data-topic="BiodbConnBase" data-id="setUrl"><a href='../../biodb/html/BiodbConnBase.html#method-BiodbConnBase-setUrl'><code>biodb::BiodbConnBase$setUrl()</code></a></span></li>
<li><span class="pkg-link" data-pkg="biodb" data-topic="BiodbConnBase" data-id="setWsUrl"><a href='../../biodb/html/BiodbConnBase.html#method-BiodbConnBase-setWsUrl'><code>biodb::BiodbConnBase$setWsUrl()</code></a></span></li>
<li><span class="pkg-link" data-pkg="biodb" data-topic="BiodbConnBase" data-id="updatePropertiesDefinition"><a href='../../biodb/html/BiodbConnBase.html#method-BiodbConnBase-updatePropertiesDefinition'><code>biodb::BiodbConnBase$updatePropertiesDefinition()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-new"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-new}{}}}
\subsection{Method \code{new()}}{
New instance initializer. Connector objects must not be created directly.
Instead, you create new connector instances through the BiodbFactory
instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$new(id = NA_character_, cache.id = NA_character_, bdb, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The ID of the connector instance.}

\item{\code{cache.id}}{The Cache ID of the connector instance.}

\item{\code{bdb}}{The BiodbMain instance.}

\item{\code{...}}{Remaining arguments will be passed to the constructor of the
super class.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-getBiodb"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-getBiodb}{}}}
\subsection{Method \code{getBiodb()}}{
Returns the biodb main class instance to which this object is
attached.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$getBiodb()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The main biodb instance.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-getId"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-getId}{}}}
\subsection{Method \code{getId()}}{
Get the identifier of this connector.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$getId()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The identifier of this connector.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-print"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-print}{}}}
\subsection{Method \code{print()}}{
Prints a description of this connector.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-correctIds"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-correctIds}{}}}
\subsection{Method \code{correctIds()}}{
Correct a vector of IDs by formatting them to the database official
format, if required and possible.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$correctIds(ids)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ids}}{A character vector of IDs.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The vector of IDs corrected.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-getEntry"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-getEntry}{}}}
\subsection{Method \code{getEntry()}}{
Return the entry corresponding to this ID. You can pass a vector of
IDs, and you will get a list of entries.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$getEntry(id, drop = TRUE, nulls = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{A character vector containing entry identifiers.}

\item{\code{drop}}{If set to TRUE and only one entry is requrested, then the
returned value will be a single BiodbEntry object, otherwise it will be
a list of BiodbEntry objects.}

\item{\code{nulls}}{If set to TRUE, NULL entries are preserved. This ensures
that the output list has the same length than the input vector \code{id}.
Otherwise they are removed from the final list.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of BiodbEntry objects, the same size of the vector of
IDs. The list will contain NULL values for invalid IDs. If drop is set
to TRUE and only one etrny was requested then a single BiodbEntry is
returned instead of a list.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-getCacheFile"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-getCacheFile}{}}}
\subsection{Method \code{getCacheFile()}}{
Get the path to the persistent cache file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$getCacheFile(entry.id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{entry.id}}{The identifiers (e.g.: accession numbers) as a
character vector of the database entries.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character vector, the same length as the vector of IDs,
containing the paths to the cache files corresponding to the requested
entry IDs.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-getEntryContent"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-getEntryContent}{}}}
\subsection{Method \code{getEntryContent()}}{
Get the contents of database entries from IDs (accession numbers).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$getEntryContent(id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{A character vector of entry IDs.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character vector containing the contents of the requested
IDs. If no content is available for an entry ID, then NA will be used.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-getEntryContentFromDb"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-getEntryContentFromDb}{}}}
\subsection{Method \code{getEntryContentFromDb()}}{
Get the contents of entries directly from the database. A direct
request or an access to the database will be made in order to retrieve the
contents. No access to the biodb cache system will be made.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$getEntryContentFromDb(entry.id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{entry.id}}{A character vector with the IDs of entries to retrieve.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character vector, the same size of entry.id, with
contents of the requested entries. An NA value will be set for the content
of each entry for which the retrieval failed.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-getEntryContentRequest"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-getEntryContentRequest}{}}}
\subsection{Method \code{getEntryContentRequest()}}{
Gets the URL to use in order to get the contents of the specified
entries.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$getEntryContentRequest(entry.id, concatenate = TRUE, max.length = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{entry.id}}{A character vector with the IDs of entries to retrieve.}

\item{\code{concatenate}}{If set to TRUE, then try to build as few URLs as
possible, sending requests with several identifiers at once.}

\item{\code{max.length}}{The maximum length of the URLs to return, in
number of characters.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A vector of URL strings.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-getEntryIds"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-getEntryIds}{}}}
\subsection{Method \code{getEntryIds()}}{
Get entry identifiers from the database. More arguments can be given,
depending on implementation in specific databases. For mass databases the
ms.level argument can also be set.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$getEntryIds(max.results = 0, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{max.results}}{The maximum of elements to return from the method.}

\item{\code{...}}{Arguments specific to connectors.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character vector containing entry IDs from the database. An empty
vector for a remote database may mean that the database does not support
requesting for entry accessions.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-getNbEntries"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-getNbEntries}{}}}
\subsection{Method \code{getNbEntries()}}{
Get the number of entries contained in this database.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$getNbEntries(count = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{count}}{If set to TRUE and no straightforward way exists to get number
of entries, count the output of getEntryIds().}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The number of entries in the database, as an integer.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-isEditable"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-isEditable}{}}}
\subsection{Method \code{isEditable()}}{
Tests if this connector is able to edit the database (i.e.: the connector
class implements the interface BiodbEditable). If this connector is
editable, then you can call allowEditing() to enable editing.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$isEditable()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns TRUE if the database is editable.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-editingIsAllowed"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-editingIsAllowed}{}}}
\subsection{Method \code{editingIsAllowed()}}{
Tests if editing is allowed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$editingIsAllowed()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
TRUE if editing is allowed for this database, FALSE
otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-allowEditing"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-allowEditing}{}}}
\subsection{Method \code{allowEditing()}}{
Allows editing for this database.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$allowEditing()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-disallowEditing"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-disallowEditing}{}}}
\subsection{Method \code{disallowEditing()}}{
Disallows editing for this database.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$disallowEditing()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-setEditingAllowed"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-setEditingAllowed}{}}}
\subsection{Method \code{setEditingAllowed()}}{
Allow or disallow editing for this database.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$setEditingAllowed(allow)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{allow}}{A logical value.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-addNewEntry"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-addNewEntry}{}}}
\subsection{Method \code{addNewEntry()}}{
Adds a new entry to the database. The passed entry must have been previously
created from scratch using BiodbFactory :createNewEntry() or cloned from an
existing entry using BiodbEntry :clone().
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$addNewEntry(entry)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{entry}}{The new entry to add. It must be a valid BiodbEntry object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-isWritable"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-isWritable}{}}}
\subsection{Method \code{isWritable()}}{
Tests if this connector is able to write into the database.  If this
connector is writable, then you can call allowWriting() to enable writing.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$isWritable()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns TRUE if the database is writable.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-allowWriting"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-allowWriting}{}}}
\subsection{Method \code{allowWriting()}}{
Allows the connector to write into this database.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$allowWriting()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-disallowWriting"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-disallowWriting}{}}}
\subsection{Method \code{disallowWriting()}}{
Disallows the connector to write into this database.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$disallowWriting()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-setWritingAllowed"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-setWritingAllowed}{}}}
\subsection{Method \code{setWritingAllowed()}}{
Allows or disallows writing for this database.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$setWritingAllowed(allow)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{allow}}{If set to TRUE, allows writing.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-writingIsAllowed"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-writingIsAllowed}{}}}
\subsection{Method \code{writingIsAllowed()}}{
Tests if the connector has access right to the database.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$writingIsAllowed()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
TRUE if writing is allowed for this database, FALSE
otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-write"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-write}{}}}
\subsection{Method \code{write()}}{
Writes into the database. All modifications made to the database since
the last time write() was called will be saved.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$write()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-isSearchableByField"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-isSearchableByField}{}}}
\subsection{Method \code{isSearchableByField()}}{
Tests if a field can be used to search entries when using method
searchForEntries().
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$isSearchableByField(field = NULL, field.type = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field}}{The name of the field.}

\item{\code{field.type}}{The field type.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns TRUE if the database is searchable using the specified
field or searchable by any field of the specified type, FALSE otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-getSearchableFields"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-getSearchableFields}{}}}
\subsection{Method \code{getSearchableFields()}}{
Get the list of all searchable fields.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$getSearchableFields()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A character vector containing all searchable fields for this
connector.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-searchForEntries"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-searchForEntries}{}}}
\subsection{Method \code{searchForEntries()}}{
Searches the database for entries whose name matches the specified name.
Returns a character vector of entry IDs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$searchForEntries(fields = NULL, max.results = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fields}}{A list of fields on which to filter entries. To get a match,
all fields must be matched (i.e. logical AND). The keys of the list are the
entry field names on which to filter, and the values are the filtering
parameters. For character fields, the filter parameter is a character vector
in which all strings must be found inside the field's value. For numeric
fields, the filter parameter is either a list specifying a min-max range
(\code{list(min=1.0, max=2.5)}) or a value with a tolerance in delta
(\code{list(value=2.0, delta=0.1)}) or ppm (\code{list(value=2.0, ppm=1.0)}).}

\item{\code{max.results}}{If set, the number of returned IDs is limited to this
number.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character vector of entry IDs whose name matches the requested
name.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-searchByName"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-searchByName}{}}}
\subsection{Method \code{searchByName()}}{
DEPRECATED. Use searchForEntries() instead.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$searchByName(name, max.results = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{A character value to search inside name fields.}

\item{\code{max.results}}{If set, the number of returned IDs is limited to this
number.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character vector of entry IDs whose name matches the
requested name.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-isDownloadable"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-isDownloadable}{}}}
\subsection{Method \code{isDownloadable()}}{
Tests if the connector can download the database.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$isDownloadable()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns TRUE if the database is downloadable.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-isDownloaded"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-isDownloaded}{}}}
\subsection{Method \code{isDownloaded()}}{
Tests if the database has been downloaded.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$isDownloaded()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
TRUE if the database content has already been downloaded.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-requiresDownload"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-requiresDownload}{}}}
\subsection{Method \code{requiresDownload()}}{
Tests if the connector requires the download of the database.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$requiresDownload()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
TRUE if the connector requires download of the database.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-getDownloadPath"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-getDownloadPath}{}}}
\subsection{Method \code{getDownloadPath()}}{
Gets the path where the downloaded content is written.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$getDownloadPath()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The path where the downloaded database is written.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-setDownloadedFile"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-setDownloadedFile}{}}}
\subsection{Method \code{setDownloadedFile()}}{
Set the downloaded file into the cache.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$setDownloadedFile(src, action = c("copy", "move"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{src}}{Path to the downloaded file.}

\item{\code{action}}{Specifies if files have to be moved or copied into the cache.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-isExtracted"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-isExtracted}{}}}
\subsection{Method \code{isExtracted()}}{
Tests if the downloaded database has been extracted (in case the
database needs extraction).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$isExtracted()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
TRUE if the downloaded database content has been
extracted, FALSE otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-download"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-download}{}}}
\subsection{Method \code{download()}}{
Downloads the database content locally.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$download()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-isRemotedb"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-isRemotedb}{}}}
\subsection{Method \code{isRemotedb()}}{
Tests if the connector is connected to a remote database.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$isRemotedb()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns TRUE if the database is a remote database."
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-isCompounddb"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-isCompounddb}{}}}
\subsection{Method \code{isCompounddb()}}{
Tests if the connector's database is a compound database.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$isCompounddb()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns TRUE if the database is a compound database.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-searchCompound"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-searchCompound}{}}}
\subsection{Method \code{searchCompound()}}{
This method is deprecated. Use searchForEntries() instead.
Searches for compounds by name and/or by mass. At least one of name or
mass must be set.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$searchCompound(
  name = NULL,
  mass = NULL,
  mass.field = NULL,
  mass.tol = 0.01,
  mass.tol.unit = "plain",
  max.results = 0
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of a compound to search for.}

\item{\code{mass}}{The searched mass.}

\item{\code{mass.field}}{For searching by mass, you must indicate a mass field to
use ('monoisotopic.mass', 'molecular.mass', 'average.mass' or
'nominal.mass').}

\item{\code{mass.tol}}{The tolerance value on the molecular mass.}

\item{\code{mass.tol.unit}}{The type of mass tolerance. Either 'plain' or 'ppm'.}

\item{\code{max.results}}{The maximum number of matches to return.}

\item{\code{description}}{A character vector of words or expressions to search for
inside description field. The words will be searched in order. A match will
be made only if all words are inside the description field.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character vector of entry IDs."
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-annotateMzValues"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-annotateMzValues}{}}}
\subsection{Method \code{annotateMzValues()}}{
Annotates a mass spectrum with the database. For each matching entry the
entry field values will be set inside columns appended to the data frame.
Names of these columns will use a common prefix in order to distinguish them
from other data from the input data frame.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$annotateMzValues(
  x,
  mz.tol,
  ms.mode,
  mz.tol.unit = c("plain", "ppm"),
  mass.field = "monoisotopic.mass",
  max.results = 3,
  mz.col = "mz",
  fields = NULL,
  prefix = NULL,
  insert.input.values = TRUE,
  fieldsLimit = 0
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Either a data frame or a numeric vector containing the M/Z values.}

\item{\code{mz.tol}}{The tolerance on the M/Z values.}

\item{\code{ms.mode}}{The MS mode. Set it to either 'neg' or 'pos'.}

\item{\code{mz.tol.unit}}{The type of the M/Z tolerance. Set it to either to 'ppm'
or 'plain'.}

\item{\code{mass.field}}{The mass field to use for matching M/Z values. One of:
'monoisotopic.mass', 'molecular.mass', 'average.mass', 'nominal.mass'.}

\item{\code{max.results}}{If set, it is used to limit the number of matches found
for each M/Z value. To get all the matches, set this parameter to
NA_integer_.  Default value is 3.}

\item{\code{mz.col}}{The name of the column where to find M/Z values in case x is a
data frame.}

\item{\code{fields}}{A character vector containing the additional entry fields you
would like to get for each matched entry. Each field will be output in a
different column.}

\item{\code{prefix}}{A prefix that will be inserted before the name of each added
column in the output. By default it will be set to the name of the database
followed by a dot.}

\item{\code{insert.input.values}}{Insert input values at the beginning of the
result data frame.}

\item{\code{fieldsLimit}}{The maximum of values to output for fields with multiple
values. Set it to 0 to get all values.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame containing the input values, and annotation columns
appended at the end. The first annotation column contains the IDs of the
matched entries. The following columns contain the fields you have requested
through the \code{fields} parameter.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-isMassdb"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-isMassdb}{}}}
\subsection{Method \code{isMassdb()}}{
Tests if the connector's database is a mass spectra database.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$isMassdb()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns TRUE if the database is a mass database.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-checkDb"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-checkDb}{}}}
\subsection{Method \code{checkDb()}}{
Checks that the database is correct by trying to retrieve all its
entries.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$checkDb()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-getAllVolatileCacheEntries"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-getAllVolatileCacheEntries}{}}}
\subsection{Method \code{getAllVolatileCacheEntries()}}{
Get all entries stored in the memory cache (volatile cache).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$getAllVolatileCacheEntries()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of BiodbEntry instances.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-getAllCacheEntries"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-getAllCacheEntries}{}}}
\subsection{Method \code{getAllCacheEntries()}}{
This method is deprecated.
Use getAllVolatileCacheEntries() instead.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$getAllCacheEntries()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
All entries cached in memory.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-deleteAllEntriesFromVolatileCache"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-deleteAllEntriesFromVolatileCache}{}}}
\subsection{Method \code{deleteAllEntriesFromVolatileCache()}}{
Delete all entries from the volatile cache (memory cache).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$deleteAllEntriesFromVolatileCache()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-deleteAllEntriesFromPersistentCache"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-deleteAllEntriesFromPersistentCache}{}}}
\subsection{Method \code{deleteAllEntriesFromPersistentCache()}}{
Delete all entries from the persistent cache (disk cache).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$deleteAllEntriesFromPersistentCache(deleteVolatile = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deleteVolatile}}{If TRUE deletes also all entries from the volatile
cache (memory cache).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-deleteWholePersistentCache"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-deleteWholePersistentCache}{}}}
\subsection{Method \code{deleteWholePersistentCache()}}{
Delete all files associated with this connector from the persistent
cache (disk cache).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$deleteWholePersistentCache(deleteVolatile = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deleteVolatile}}{If TRUE deletes also all entries
from the volatile cache (memory cache).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-deleteAllCacheEntries"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-deleteAllCacheEntries}{}}}
\subsection{Method \code{deleteAllCacheEntries()}}{
Delete all entries from the memory cache. This method is deprecated,
please use deleteAllEntriesFromVolatileCache() instead.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$deleteAllCacheEntries()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-getCacheId"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-getCacheId}{}}}
\subsection{Method \code{getCacheId()}}{
Gets the ID used by this connector in the disk cache.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$getCacheId()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The cache ID of this connector.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-makesRefToEntry"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-makesRefToEntry}{}}}
\subsection{Method \code{makesRefToEntry()}}{
Tests if some entry of this database makes reference to another entry of
another database.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$makesRefToEntry(id, db, oid, any = FALSE, recurse = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{A character vector of entry IDs from the connector's database.}

\item{\code{db}}{Another database connector.}

\item{\code{oid}}{A entry ID from database db.}

\item{\code{any}}{If set to TRUE, returns a single logical value: TRUE if any entry
contains a reference to oid, FALSE otherwise.}

\item{\code{recurse}}{If set to TRUE, the algorithm will follow all references to
entries from other databases, to see if it can establish an indirect link to
\code{oid}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A logical vector, the same size as \code{id}, with TRUE for each entry
making reference to \code{oid}, and FALSE otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-makeRequest"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-makeRequest}{}}}
\subsection{Method \code{makeRequest()}}{
Makes a BiodbRequest instance using the passed parameters, and set
ifself as the associated connector.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$makeRequest(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Those parameters are passed to the initializer of BiodbRequest.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The BiodbRequest instance.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-getEntryImageUrl"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-getEntryImageUrl}{}}}
\subsection{Method \code{getEntryImageUrl()}}{
Gets the URL to a picture of the entry (e.g.: a picture of the
molecule in case of a compound entry).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$getEntryImageUrl(entry.id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{entry.id}}{A character vector containing entry IDs.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character vector, the same length as \code{entry.id},
containing for each entry ID either a URL or NA if no URL exists.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-getEntryPageUrl"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-getEntryPageUrl}{}}}
\subsection{Method \code{getEntryPageUrl()}}{
Gets the URL to the page of the entry on the database web site.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$getEntryPageUrl(entry.id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{entry.id}}{A character vector with the IDs of entries to retrieve.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of BiodbUrl objects, the same length as \code{entry.id}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-getChromCol"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-getChromCol}{}}}
\subsection{Method \code{getChromCol()}}{
Gets a list of chromatographic columns contained in this database.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$getChromCol(ids = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ids}}{A character vector of entry identifiers (i.e.: accession
numbers).  Used to restrict the set of entries on which to run the
algorithm.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data.frame with two columns, one for the ID 'id' and another one
for the title 'title'.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-getMatchingMzField"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-getMatchingMzField}{}}}
\subsection{Method \code{getMatchingMzField()}}{
Gets the field to use for M/Z matching.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$getMatchingMzField()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The name of the field (one of peak.mztheo or peak.mzexp).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-setMatchingMzField"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-setMatchingMzField}{}}}
\subsection{Method \code{setMatchingMzField()}}{
Sets the field to use for M/Z matching.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$setMatchingMzField(field = c("peak.mztheo", "peak.mzexp"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field}}{The field to use for matching.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-getMzValues"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-getMzValues}{}}}
\subsection{Method \code{getMzValues()}}{
Gets a list of M/Z values contained inside the database.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$getMzValues(
  ms.mode = NULL,
  max.results = 0,
  precursor = FALSE,
  ms.level = 0
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ms.mode}}{The MS mode. Set it to either 'neg' or 'pos' to limit the
output to one mode.}

\item{\code{max.results}}{If set, it is used to limit the size of the output.}

\item{\code{precursor}}{If set to TRUE, then restrict the search to precursor peaks.}

\item{\code{ms.level}}{The MS level to which you want to restrict your search.  0
means that you want to search in all levels.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric vector containing M/Z values.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-getNbPeaks"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-getNbPeaks}{}}}
\subsection{Method \code{getNbPeaks()}}{
Gets the number of peaks contained in the database.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$getNbPeaks(mode = NULL, ids = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mode}}{The MS mode. Set it to either 'neg' or 'pos' to limit the
counting to one mode.}

\item{\code{ids}}{A character vector of entry identifiers (i.e.: accession
numbers).  Used to restrict the set of entries on which to run the
algorithm.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The number of peaks, as an integer.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-filterEntriesOnRt"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-filterEntriesOnRt}{}}}
\subsection{Method \code{filterEntriesOnRt()}}{
Filters a list of entries on retention time values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$filterEntriesOnRt(
  entry.ids,
  rt,
  rt.unit,
  rt.tol,
  rt.tol.exp,
  chrom.col.ids,
  match.rt
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{entry.ids}}{A character vector of entry IDs.}

\item{\code{rt}}{A vector of retention times to match. Used if input.df is not set.
Unit is specified by rt.unit parameter.}

\item{\code{rt.unit}}{The unit for submitted retention times. Either 's' or 'min'.}

\item{\code{rt.tol}}{The plain tolerance (in seconds) for retention times: input.rt
\itemize{
\item rt.tol <= database.rt <= input.rt + rt.tol.
}}

\item{\code{rt.tol.exp}}{A special exponent tolerance for retention times: input.rt
\itemize{
\item input.rt ** rt.tol.exp <= database.rt <= input.rt + input.rt **
rt.tol.exp. This exponent is applied on the RT value in seconds. If both
rt.tol and rt.tol.exp are set, the inequality expression becomes input.rt -
rt.tol - input.rt ** rt.tol.exp <= database.rt <= input.rt + rt.tol +
input.rt ** rt.tol.exp.
}}

\item{\code{chrom.col.ids}}{IDs of chromatographic columns on which to match the
retention time.}

\item{\code{match.rt}}{If set to TRUE, filters on RT values, otherwise does not do
any filtering.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character vector containing entry IDs after filtering.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-searchForMassSpectra"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-searchForMassSpectra}{}}}
\subsection{Method \code{searchForMassSpectra()}}{
Searches for entries (i.e.: spectra) that contain a peak around the given
M/Z value. Entries can also be filtered on RT values. You can input either a
list of M/Z values through mz argument and set a tolerance with mz.tol
argument, or two lists of minimum and maximum M/Z values through mz.min and
mz.max arguments.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$searchForMassSpectra(
  mz.min = NULL,
  mz.max = NULL,
  mz = NULL,
  mz.tol = NULL,
  mz.tol.unit = c("plain", "ppm"),
  rt = NULL,
  rt.unit = c("s", "min"),
  rt.tol = NULL,
  rt.tol.exp = NULL,
  chrom.col.ids = NULL,
  precursor = FALSE,
  min.rel.int = 0,
  ms.mode = NULL,
  max.results = 0,
  ms.level = 0,
  include.ids = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mz.min}}{A vector of minimum M/Z values.}

\item{\code{mz.max}}{A vector of maximum M/Z values. Its length must be the same as
\code{mz.min}.}

\item{\code{mz}}{A vector of M/Z values.}

\item{\code{mz.tol}}{The M/Z tolerance, whose unit is defined by mz.tol.unit.}

\item{\code{mz.tol.unit}}{The type of the M/Z tolerance. Set it to either to 'ppm'
or 'plain'.}

\item{\code{rt}}{A vector of retention times to match. Used if input.df is not set.
Unit is specified by rt.unit parameter.}

\item{\code{rt.unit}}{The unit for submitted retention times. Either 's' or 'min'.}

\item{\code{rt.tol}}{The plain tolerance (in seconds) for retention times: input.rt
\itemize{
\item rt.tol <= database.rt <= input.rt + rt.tol.
}}

\item{\code{rt.tol.exp}}{A special exponent tolerance for retention times: input.rt
\itemize{
\item input.rt ** rt.tol.exp <= database.rt <= input.rt + input.rt **
rt.tol.exp. This exponent is applied on the RT value in seconds. If both
rt.tol and rt.tol.exp are set, the inequality expression becomes input.rt -
rt.tol - input.rt ** rt.tol.exp <= database.rt <= input.rt + rt.tol +
input.rt ** rt.tol.exp.
}}

\item{\code{chrom.col.ids}}{IDs of chromatographic columns on which to match the
retention time.}

\item{\code{precursor}}{If set to TRUE, then restrict the search to precursor peaks.}

\item{\code{min.rel.int}}{The minimum relative intensity, in percentage (i.e.:
float number between 0 and 100).}

\item{\code{ms.mode}}{The MS mode. Set it to either 'neg' or 'pos'.}

\item{\code{max.results}}{If set, it is used to limit the number of matches found
for each M/Z value.}

\item{\code{ms.level}}{The MS level to which you want to restrict your search.  0
means that you want to search in all levels.}

\item{\code{include.ids}}{A list of IDs to which to restrict the final results. All
IDs that are not in this list will be excluded.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character vector of spectra IDs.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-searchMsEntries"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-searchMsEntries}{}}}
\subsection{Method \code{searchMsEntries()}}{
DEPRECATED. Use searchForMassSpectra() instead.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$searchMsEntries(
  mz.min = NULL,
  mz.max = NULL,
  mz = NULL,
  mz.tol = NULL,
  mz.tol.unit = c("plain", "ppm"),
  rt = NULL,
  rt.unit = c("s", "min"),
  rt.tol = NULL,
  rt.tol.exp = NULL,
  chrom.col.ids = NULL,
  precursor = FALSE,
  min.rel.int = 0,
  ms.mode = NULL,
  max.results = 0,
  ms.level = 0
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mz.min}}{A vector of minimum M/Z values.}

\item{\code{mz.max}}{A vector of maximum M/Z values. Its length must be the same as
\code{mz.min}.}

\item{\code{mz}}{A vector of M/Z values.}

\item{\code{mz.tol}}{The M/Z tolerance, whose unit is defined by mz.tol.unit.}

\item{\code{mz.tol.unit}}{The type of the M/Z tolerance. Set it to either to 'ppm'
or 'plain'.}

\item{\code{rt}}{A vector of retention times to match. Used if input.df is not set.
Unit is specified by rt.unit parameter.}

\item{\code{rt.unit}}{The unit for submitted retention times. Either 's' or 'min'.}

\item{\code{rt.tol}}{The plain tolerance (in seconds) for retention times: input.rt
\itemize{
\item rt.tol <= database.rt <= input.rt + rt.tol.
}}

\item{\code{rt.tol.exp}}{A special exponent tolerance for retention times: input.rt
\itemize{
\item input.rt ** rt.tol.exp <= database.rt <= input.rt + input.rt **
rt.tol.exp. This exponent is applied on the RT value in seconds. If both
rt.tol and rt.tol.exp are set, the inequality expression becomes input.rt -
rt.tol - input.rt ** rt.tol.exp <= database.rt <= input.rt + rt.tol +
input.rt ** rt.tol.exp.
}}

\item{\code{chrom.col.ids}}{IDs of chromatographic columns on which to match the
retention time.}

\item{\code{precursor}}{If set to TRUE, then restrict the search to precursor peaks.}

\item{\code{min.rel.int}}{The minimum relative intensity, in percentage (i.e.:
float number between 0 and 100).}

\item{\code{ms.mode}}{The MS mode. Set it to either 'neg' or 'pos'.}

\item{\code{max.results}}{If set, it is used to limit the number of matches found
for each M/Z value.}

\item{\code{ms.level}}{The MS level to which you want to restrict your search.  0
means that you want to search in all levels.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character vector of spectra IDs.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-searchMsPeaks"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-searchMsPeaks}{}}}
\subsection{Method \code{searchMsPeaks()}}{
For each M/Z value, searches for matching MS spectra and returns the
matching peaks.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$searchMsPeaks(
  input.df = NULL,
  mz = NULL,
  mz.tol = NULL,
  mz.tol.unit = c("plain", "ppm"),
  min.rel.int = 0,
  ms.mode = NULL,
  ms.level = 0,
  max.results = 0,
  chrom.col.ids = NULL,
  rt = NULL,
  rt.unit = c("s", "min"),
  rt.tol = NULL,
  rt.tol.exp = NULL,
  precursor = FALSE,
  precursor.rt.tol = NULL,
  insert.input.values = TRUE,
  prefix = NULL,
  compute = TRUE,
  fields = NULL,
  fieldsLimit = 0,
  input.df.colnames = c(mz = "mz", rt = "rt"),
  match.rt = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input.df}}{A data frame taken as input for searchMsPeaks(). It must
contain a columns 'mz', and optionaly an 'rt' column.}

\item{\code{mz}}{A vector of M/Z values to match. Used if input.df is not set.}

\item{\code{mz.tol}}{The M/Z tolerance, whose unit is defined by mz.tol.unit.}

\item{\code{mz.tol.unit}}{The type of the M/Z tolerance. Set it to either to 'ppm'
or 'plain'.}

\item{\code{min.rel.int}}{The minimum relative intensity, in percentage (i.e.:
float number between 0 and 100).}

\item{\code{ms.mode}}{The MS mode. Set it to either 'neg' or 'pos'.}

\item{\code{ms.level}}{The MS level to which you want to restrict your search.  0
means that you want to search in all levels.}

\item{\code{max.results}}{If set, it is used to limit the number of matches found
for each M/Z value.}

\item{\code{chrom.col.ids}}{IDs of chromatographic columns on which to match the
retention time.}

\item{\code{rt}}{A vector of retention times to match. Used if input.df is not set.
Unit is specified by rt.unit parameter.}

\item{\code{rt.unit}}{The unit for submitted retention times. Either 's' or 'min'.}

\item{\code{rt.tol}}{The plain tolerance (in seconds) for retention times: input.rt
\itemize{
\item rt.tol <= database.rt <= input.rt + rt.tol.
}}

\item{\code{rt.tol.exp}}{A special exponent tolerance for retention times: input.rt
\itemize{
\item input.rt ** rt.tol.exp <= database.rt <= input.rt + input.rt **
rt.tol.exp. This exponent is applied on the RT value in seconds. If both
rt.tol and rt.tol.exp are set, the inequality expression becomes input.rt -
rt.tol - input.rt ** rt.tol.exp <= database.rt <= input.rt + rt.tol +
input.rt ** rt.tol.exp.
}}

\item{\code{precursor}}{If set to TRUE, then restrict the search to precursor peaks.}

\item{\code{precursor.rt.tol}}{The RT tolerance used when matching the precursor.}

\item{\code{insert.input.values}}{Insert input values at the beginning of the
result data frame.}

\item{\code{prefix}}{Add prefix on column names of result data frame.}

\item{\code{compute}}{If set to TRUE, use the computed values when converting found
entries to data frame.}

\item{\code{fields}}{A character vector of field names to output. The data frame
output will be restricted to this list of fields.}

\item{\code{fieldsLimit}}{The maximum of values to output for fields with multiple
values. Set it to 0 to get all values.}

\item{\code{input.df.colnames}}{Names of the columns in the input data frame.}

\item{\code{match.rt}}{If set to TRUE, match also RT values.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame with at least input MZ and RT columns, and annotation
columns prefixed with \code{prefix} if set. For each matching found a row is
output. Thus if n matchings are found for M/Z value x, then there will be n
rows for x, each for a different match. The number of matching found for
each M/Z value is limited to \code{max.results}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-msmsSearch"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-msmsSearch}{}}}
\subsection{Method \code{msmsSearch()}}{
Searches MSMS spectra matching a template spectrum. The mz.tol
parameter is applied on the precursor search.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$msmsSearch(
  spectrum,
  precursor.mz,
  mz.tol,
  mz.tol.unit = c("plain", "ppm"),
  ms.mode,
  npmin = 2,
  dist.fun = c("wcosine", "cosine", "pkernel", "pbachtttarya"),
  msms.mz.tol = 3,
  msms.mz.tol.min = 0.005,
  max.results = 0
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{spectrum}}{A template spectrum to match inside the database.}

\item{\code{precursor.mz}}{The M/Z value of the precursor peak of the mass spectrum.}

\item{\code{mz.tol}}{The M/Z tolerance, whose unit is defined by mz.tol.unit.}

\item{\code{mz.tol.unit}}{The type of the M/Z tolerance. Set it to either to
'ppm' or 'plain'.}

\item{\code{ms.mode}}{The MS mode. Set it to either 'neg' or 'pos'.}

\item{\code{npmin}}{The minimum number of peak to detect a match (2 is recommended).}

\item{\code{dist.fun}}{The distance function used to compute the distance
betweem two mass spectra.}

\item{\code{msms.mz.tol}}{M/Z tolerance to apply while matching MSMS spectra.
In PPM.}

\item{\code{msms.mz.tol.min}}{Minimum of the M/Z tolerance (plain unit). If
the M/Z tolerance computed with \code{msms.mz.tol} is lower than
\code{msms.mz.tol.min}, then \code{msms.mz.tol.min} will be used.}

\item{\code{max.results}}{If set, it is used to limit the number of matches
found for each M/Z value.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame with columns \code{id}, \code{score} and \verb{peak.*}. Each
\verb{peak.*} column corresponds to a peak in the input spectrum, in the
same order and gives the number of the peak that was matched with it
inside the matched spectrum whose ID is inside the \code{id} column.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-collapseResultsDataFrame"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-collapseResultsDataFrame}{}}}
\subsection{Method \code{collapseResultsDataFrame()}}{
Collapse rows of a results data frame, by outputing a data frame with
only one row for each MZ/RT value.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$collapseResultsDataFrame(
  results.df,
  mz.col = "mz",
  rt.col = "rt",
  sep = "|"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{results.df}}{Results data frame.}

\item{\code{mz.col}}{The name of the M/Z column in the results data frame.}

\item{\code{rt.col}}{The name of the RT column in the results data frame.}

\item{\code{sep}}{The separator used to concatenate values, when collapsing results
data frame.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame with rows collapsed."
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-searchMzRange"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-searchMzRange}{}}}
\subsection{Method \code{searchMzRange()}}{
Find spectra in the given M/Z range. Returns a list of spectra IDs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$searchMzRange(
  mz.min,
  mz.max,
  min.rel.int = 0,
  ms.mode = NULL,
  max.results = 0,
  precursor = FALSE,
  ms.level = 0
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mz.min}}{A vector of minimum M/Z values.}

\item{\code{mz.max}}{A vector of maximum M/Z values. Its length must be the
same as \code{mz.min}.}

\item{\code{min.rel.int}}{The minimum relative intensity, in percentage (i.e.:
float number between 0 and 100).}

\item{\code{ms.mode}}{The MS mode. Set it to either 'neg' or 'pos'.}

\item{\code{max.results}}{If set, it is used to limit the number of matches
found for each M/Z value.}

\item{\code{precursor}}{If set to TRUE, then restrict the search to precursor
peaks.}

\item{\code{ms.level}}{The MS level to which you want to restrict your search.
0 means that you want to search in all levels.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character vector of spectra IDs.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-searchMzTol"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-searchMzTol}{}}}
\subsection{Method \code{searchMzTol()}}{
Find spectra containg a peak around the given M/Z value. Returns a
character vector of spectra IDs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$searchMzTol(
  mz,
  mz.tol,
  mz.tol.unit = "plain",
  min.rel.int = 0,
  ms.mode = NULL,
  max.results = 0,
  precursor = FALSE,
  ms.level = 0
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mz}}{A vector of M/Z values.}

\item{\code{mz.tol}}{The M/Z tolerance, whose unit is defined by mz.tol.unit.}

\item{\code{mz.tol.unit}}{The type of the M/Z tolerance. Set it to either to
'ppm' or 'plain'.}

\item{\code{min.rel.int}}{The minimum relative intensity, in percentage (i.e.:
float number between 0 and 100).}

\item{\code{ms.mode}}{The MS mode. Set it to either 'neg' or 'pos'.}

\item{\code{max.results}}{If set, it is used to limit the number of matches
found for each M/Z value.}

\item{\code{precursor}}{If set to TRUE, then restrict the search to precursor
peaks.}

\item{\code{ms.level}}{The MS level to which you want to restrict your search.
0 means that you want to search in all levels.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character vector of spectra IDs.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConn-clone"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConn-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConn$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
