% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiodbSqlQuery.R
\name{BiodbSqlQuery}
\alias{BiodbSqlQuery}
\title{This class handles an SQL Query.}
\description{
This class handles an SQL Query.

This class handles an SQL Query.
}
\details{
This class represents an SQL query. It is used internally to generate an SQL
query string.
}
\seealso{
\code{\link{BiodbRequestScheduler}}, \code{\link{BiodbRequest}}.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-BiodbSqlQuery-new}{\code{BiodbSqlQuery$new()}}
\item \href{#method-BiodbSqlQuery-setTable}{\code{BiodbSqlQuery$setTable()}}
\item \href{#method-BiodbSqlQuery-addField}{\code{BiodbSqlQuery$addField()}}
\item \href{#method-BiodbSqlQuery-setDistinct}{\code{BiodbSqlQuery$setDistinct()}}
\item \href{#method-BiodbSqlQuery-setLimit}{\code{BiodbSqlQuery$setLimit()}}
\item \href{#method-BiodbSqlQuery-addJoin}{\code{BiodbSqlQuery$addJoin()}}
\item \href{#method-BiodbSqlQuery-setWhere}{\code{BiodbSqlQuery$setWhere()}}
\item \href{#method-BiodbSqlQuery-getJoin}{\code{BiodbSqlQuery$getJoin()}}
\item \href{#method-BiodbSqlQuery-getWhere}{\code{BiodbSqlQuery$getWhere()}}
\item \href{#method-BiodbSqlQuery-getFields}{\code{BiodbSqlQuery$getFields()}}
\item \href{#method-BiodbSqlQuery-toString}{\code{BiodbSqlQuery$toString()}}
\item \href{#method-BiodbSqlQuery-clone}{\code{BiodbSqlQuery$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbSqlQuery-new"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbSqlQuery-new}{}}}
\subsection{Method \code{new()}}{
Initializer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbSqlQuery$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbSqlQuery-setTable"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbSqlQuery-setTable}{}}}
\subsection{Method \code{setTable()}}{
Set the table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbSqlQuery$setTable(table)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{table}}{The table name.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbSqlQuery-addField"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbSqlQuery-addField}{}}}
\subsection{Method \code{addField()}}{
Set the fields.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbSqlQuery$addField(table = NULL, field)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{table}}{The table name.}

\item{\code{field}}{A field name.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbSqlQuery-setDistinct"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbSqlQuery-setDistinct}{}}}
\subsection{Method \code{setDistinct()}}{
Set or unset distinct modifier.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbSqlQuery$setDistinct(distinct)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{distinct}}{Either TRUE or FALSE for setting or unsetting the distinct
flag.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbSqlQuery-setLimit"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbSqlQuery-setLimit}{}}}
\subsection{Method \code{setLimit()}}{
Set results limit.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbSqlQuery$setLimit(limit)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{limit}}{The limit to set, as an integer value.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbSqlQuery-addJoin"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbSqlQuery-addJoin}{}}}
\subsection{Method \code{addJoin()}}{
Add a join.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbSqlQuery$addJoin(table1, field1, table2, field2)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{table1}}{The first table.}

\item{\code{field1}}{The field of the first table.}

\item{\code{table2}}{The second table.}

\item{\code{field2}}{The field of the second table.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbSqlQuery-setWhere"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbSqlQuery-setWhere}{}}}
\subsection{Method \code{setWhere()}}{
Set the where clause.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbSqlQuery$setWhere(expr)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{expr}}{A BiodbSqlExpr representing the "where" clause.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbSqlQuery-getJoin"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbSqlQuery-getJoin}{}}}
\subsection{Method \code{getJoin()}}{
Builds and returns the join expression.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbSqlQuery$getJoin()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A character vector representing the join expression.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbSqlQuery-getWhere"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbSqlQuery-getWhere}{}}}
\subsection{Method \code{getWhere()}}{
Gets the where expression.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbSqlQuery$getWhere()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The BiodbSqlExpr instance representing the "where" clause.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbSqlQuery-getFields"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbSqlQuery-getFields}{}}}
\subsection{Method \code{getFields()}}{
Gets the fields to retrieve.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbSqlQuery$getFields()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A string containing the list of fields to retrieve.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbSqlQuery-toString"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbSqlQuery-toString}{}}}
\subsection{Method \code{toString()}}{
Generates the string representation of this query.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbSqlQuery$toString()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A string containing the full SQL query.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbSqlQuery-clone"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbSqlQuery-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbSqlQuery$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
