% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiodbTestMsgAck.R
\name{BiodbTestMsgAck}
\alias{BiodbTestMsgAck}
\title{A class for acknowledging messages during tests.}
\description{
A class for acknowledging messages during tests.

A class for acknowledging messages during tests.
}
\details{
This observer is used to call a testthat::expect_*() method each time a
message is received. This is used when running tests on Travis-CI, so Travis
does not stop tests because no change is detected in output.
}
\examples{
# To use the acknowledger, set ack=TRUE when creating the Biodb test
# instance:
biodb <- biodb::createBiodbTestInstance(ack=TRUE)

# Terminate the BiodbMain instance
biodb$terminate()

}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-BiodbTestMsgAck-new}{\code{BiodbTestMsgAck$new()}}
\item \href{#method-BiodbTestMsgAck-notifyProgress}{\code{BiodbTestMsgAck$notifyProgress()}}
\item \href{#method-BiodbTestMsgAck-clone}{\code{BiodbTestMsgAck$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbTestMsgAck-new"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbTestMsgAck-new}{}}}
\subsection{Method \code{new()}}{
New instance initializer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbTestMsgAck$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbTestMsgAck-notifyProgress"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbTestMsgAck-notifyProgress}{}}}
\subsection{Method \code{notifyProgress()}}{
Call back method used to get progress advancement of a long process.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbTestMsgAck$notifyProgress(what, index, total)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{what}}{The reason as a character value.}

\item{\code{index}}{The index number representing the progress.}

\item{\code{total}}{The total number to reach for completing the process.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbTestMsgAck-clone"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbTestMsgAck-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbTestMsgAck$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
