% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiodbUrl.R
\name{BiodbUrl}
\alias{BiodbUrl}
\title{Class URL.}
\description{
Class URL.

Class URL.
}
\details{
This class represents a URL object that can be used in requests.
}
\examples{
# Create a URL object
u <- c("https://www.uniprot.org", "uniprot")
p <- c(query="reviewed:yes+AND+organism:9606",
       columns='id,entry name,protein names',
       format="tab")
url <- BiodbUrl$new(url=u, params=p)
url$toString()

}
\seealso{
\code{\link{BiodbRequestScheduler}}, \code{\link{BiodbRequest}}.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-BiodbUrl-new}{\code{BiodbUrl$new()}}
\item \href{#method-BiodbUrl-getDomain}{\code{BiodbUrl$getDomain()}}
\item \href{#method-BiodbUrl-setUrl}{\code{BiodbUrl$setUrl()}}
\item \href{#method-BiodbUrl-setParam}{\code{BiodbUrl$setParam()}}
\item \href{#method-BiodbUrl-print}{\code{BiodbUrl$print()}}
\item \href{#method-BiodbUrl-toString}{\code{BiodbUrl$toString()}}
\item \href{#method-BiodbUrl-clone}{\code{BiodbUrl$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbUrl-new"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbUrl-new}{}}}
\subsection{Method \code{new()}}{
Initializer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbUrl$new(url = character(), params = character(), chompExtraSlashes = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{The URL to access, as a character vector.}

\item{\code{params}}{The list of parameters to append to this URL.}

\item{\code{chompExtraSlashes}}{If set to TRUE, then slashes at the end and the
beginning of each element of the url vector parameter will be removed before
proper concatenation.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbUrl-getDomain"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbUrl-getDomain}{}}}
\subsection{Method \code{getDomain()}}{
Gets the domain.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbUrl$getDomain()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The domain.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbUrl-setUrl"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbUrl-setUrl}{}}}
\subsection{Method \code{setUrl()}}{
Sets the base URL string.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbUrl$setUrl(url)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{The base URL string.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbUrl-setParam"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbUrl-setParam}{}}}
\subsection{Method \code{setParam()}}{
Sets a parameter.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbUrl$setParam(key, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{The parameter name.}

\item{\code{value}}{The value of the parameter.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbUrl-print"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbUrl-print}{}}}
\subsection{Method \code{print()}}{
Displays information about this instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbUrl$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
self as invisible.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbUrl-toString"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbUrl-toString}{}}}
\subsection{Method \code{toString()}}{
Gets the URL as a string representation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbUrl$toString(encode = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{encode}}{If set to TRUE, then encodes the URL.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The URL as a string, with all parameters and values set.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbUrl-clone"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbUrl-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbUrl$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
