% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExtDefinitions.R
\name{ExtDefinitions}
\alias{ExtDefinitions}
\title{Extension defintions file class}
\description{
A class for generating the definitions.yml file of a new extension package.
}
\details{
This class generates the definitions.yml of a new extension package, needed
for definining the new connector.
}
\examples{
# Generate the biodb definitions.yml file inside "inst" folder:
pkgFolder <- file.path(tempfile(), 'biodbFoo')
dir.create(pkgFolder, recursive=TRUE)
biodb::ExtDefinitions$new(path=pkgFolder, dbName='foo.db',
                          dbTitle='Foo database')$generate()

}
\section{Super classes}{
\code{\link[biodb:ExtGenerator]{biodb::ExtGenerator}} -> \code{\link[biodb:ExtFileGenerator]{biodb::ExtFileGenerator}} -> \code{ExtDefinitions}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ExtDefinitions-new}{\code{ExtDefinitions$new()}}
\item \href{#method-ExtDefinitions-clone}{\code{ExtDefinitions$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="biodb" data-topic="ExtGenerator" data-id="generate"><a href='../../biodb/html/ExtGenerator.html#method-ExtGenerator-generate'><code>biodb::ExtGenerator$generate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="biodb" data-topic="ExtGenerator" data-id="upgrade"><a href='../../biodb/html/ExtGenerator.html#method-ExtGenerator-upgrade'><code>biodb::ExtGenerator$upgrade()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtDefinitions-new"></a>}}
\if{latex}{\out{\hypertarget{method-ExtDefinitions-new}{}}}
\subsection{Method \code{new()}}{
Initializer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtDefinitions$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{See the constructor of ExtFileGenerator for the parameters.
offers this possiblity.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtDefinitions-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ExtDefinitions-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtDefinitions$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
