% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExtDescriptionFile.R
\name{ExtDescriptionFile}
\alias{ExtDescriptionFile}
\title{Extension DESCRIPTION file}
\description{
A class for generating a DESCRIPTION file for an extension package.
}
\details{
This class generates a DESCRIPTION for a biodb extension package.
}
\examples{
# Generate the DESCRIPTION file:
pkgFolder <- file.path(tempfile(), 'biodbFoo')
dir.create(pkgFolder, recursive=TRUE)
biodb::ExtDescriptionFile$new(path=pkgFolder, dbName='foo.db',
                              dbTitle='Foo database', email='j.smith@e.mail',
                              firstname='John', lastname='Smith', rcpp=TRUE,
                              entryType='xml')$generate()

}
\section{Super classes}{
\code{\link[biodb:ExtGenerator]{biodb::ExtGenerator}} -> \code{\link[biodb:ExtFileGenerator]{biodb::ExtFileGenerator}} -> \code{ExtDescriptionFile}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ExtDescriptionFile-new}{\code{ExtDescriptionFile$new()}}
\item \href{#method-ExtDescriptionFile-clone}{\code{ExtDescriptionFile$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="biodb" data-topic="ExtGenerator" data-id="generate"><a href='../../biodb/html/ExtGenerator.html#method-ExtGenerator-generate'><code>biodb::ExtGenerator$generate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="biodb" data-topic="ExtGenerator" data-id="upgrade"><a href='../../biodb/html/ExtGenerator.html#method-ExtGenerator-upgrade'><code>biodb::ExtGenerator$upgrade()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtDescriptionFile-new"></a>}}
\if{latex}{\out{\hypertarget{method-ExtDescriptionFile-new}{}}}
\subsection{Method \code{new()}}{
Initializer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtDescriptionFile$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{See the constructor of ExtFileGenerator for the parameters.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtDescriptionFile-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ExtDescriptionFile-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtDescriptionFile$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
