% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExtGenerator.R
\name{ExtGenerator}
\alias{ExtGenerator}
\title{Extension generator abstract class}
\description{
The mother class of all generators for biodb extension packages.
}
\details{
All generator classes for biodb extensions must inherit from this class.
}
\examples{
# Generate a new connector class inside the R folder:
pkgFolder <- file.path(tempfile(), 'biodbFoo')
dir.create(pkgFolder, recursive=TRUE)
biodb::ExtConnClass$new(path=pkgFolder, dbName='foo.db',
                        dbTitle='Foo database',
                        connType='mass', remote=TRUE)$generate()


## ------------------------------------------------
## Method `ExtGenerator$generate`
## ------------------------------------------------

# Generate a new extension package:
pkgFolder <- file.path(tempfile(), 'biodbFoo')
biodb::ExtPackage$new(pkgFolder)$generate()
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ExtGenerator-new}{\code{ExtGenerator$new()}}
\item \href{#method-ExtGenerator-generate}{\code{ExtGenerator$generate()}}
\item \href{#method-ExtGenerator-upgrade}{\code{ExtGenerator$upgrade()}}
\item \href{#method-ExtGenerator-clone}{\code{ExtGenerator$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtGenerator-new"></a>}}
\if{latex}{\out{\hypertarget{method-ExtGenerator-new}{}}}
\subsection{Method \code{new()}}{
Initializer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtGenerator$new(
  path,
  loadCfg = TRUE,
  saveCfg = TRUE,
  pkgName = getPkgName(path),
  email = "author@e.mail",
  dbName = "foo.db",
  dbTitle = "Foo database",
  pkgLicense = getLicenses(),
  firstname = "Firstname of author",
  lastname = "Lastname of author",
  newPkg = FALSE,
  connType = getConnTypes(),
  entryType = getEntryTypes(),
  editable = FALSE,
  writable = FALSE,
  remote = FALSE,
  downloadable = FALSE,
  makefile = FALSE,
  travis = FALSE,
  rcpp = FALSE,
  vignetteName = getPkgName(path),
  githubRepos = getReposName(path, default = "myaccount/myrepos")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{The path to the package folder.}

\item{\code{loadCfg}}{Set to FALSE to disable loading of tag values from config
file "biodb_ext.yml".}

\item{\code{saveCfg}}{Set to FALSE to disable saving of tag values into config
file "biodb_ext.yml".}

\item{\code{pkgName}}{The package name. If set to NULL, the folder name pointer by
the "path" paramater will be used as the package name.}

\item{\code{email}}{The email of the author.}

\item{\code{dbName}}{The name of the database (in biodb format "my.db.name"),
that will be used in "definitions.yml" file and for connector and entry
classes.}

\item{\code{dbTitle}}{The official name of the database (e.g.: HMDB, UniProtKB,
KEGG).}

\item{\code{pkgLicense}}{The license of the package.}

\item{\code{firstname}}{The firstname of the author.}

\item{\code{lastname}}{The lastname of the author.}

\item{\code{newPkg}}{Set to TRUE if the package is not yet published on
Bioconductor.}

\item{\code{connType}}{The type of connector class to implement.}

\item{\code{entryType}}{The type of entry class to implement.}

\item{\code{editable}}{Set to TRUE to allow the generated connector to create new
entries in memory.}

\item{\code{writable}}{Set to TRUE to enable the generated connector to write into
the database.}

\item{\code{remote}}{Set to TRUE if the database to connect to is not local.}

\item{\code{downloadable}}{Set to TRUE if the database needs to be downloaded or
offers this possiblity.}

\item{\code{makefile}}{Set to TRUE if you want a Makefile to be generated.}

\item{\code{travis}}{Set to TRUE if you want a .travis.yml file to be generated.}

\item{\code{rcpp}}{Set to TRUE to enable Rcpp C/C++ code inside the package.}

\item{\code{vignetteName}}{Set to the name of the default/main vignette.}

\item{\code{githubRepos}}{Set to the name of the associated GitHub repository.
Example: myaccount/myrepos.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtGenerator-generate"></a>}}
\if{latex}{\out{\hypertarget{method-ExtGenerator-generate}{}}}
\subsection{Method \code{generate()}}{
Generates the destination file(s).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtGenerator$generate(overwrite = FALSE, fail = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{overwrite}}{If set to TRUE and destination files exist, overwrite the
destination files.}

\item{\code{fail}}{If set to FALSE, do not fail if destination files exist, just do
nothing and return.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Generate a new extension package:
pkgFolder <- file.path(tempfile(), 'biodbFoo')
biodb::ExtPackage$new(pkgFolder)$generate()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtGenerator-upgrade"></a>}}
\if{latex}{\out{\hypertarget{method-ExtGenerator-upgrade}{}}}
\subsection{Method \code{upgrade()}}{
Upgrade the destination file(s).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtGenerator$upgrade(generate = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{generate}}{If set to FALSE, and destination file(s) do not exist, then
do not generate them.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtGenerator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ExtGenerator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtGenerator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
