% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExtMakefile.R
\name{ExtMakefile}
\alias{ExtMakefile}
\title{Extension Makefile}
\description{
A class for generating a Makefile for an extension package.
}
\details{
This class generates a Makefile, usable on UNIX-like platforms, for managing
a biodb extension package. Targets are automatically generated for running
CRAN check, Bioconductor check, testthat tests, compiling, generating
documentation, cleaning, etc.
}
\examples{
# Generate a new connector class inside R folder:
pkgFolder <- file.path(tempfile(), 'biodbFoo')
dir.create(pkgFolder, recursive=TRUE)
biodb::ExtMakefile$new(path=pkgFolder)$generate()

}
\section{Super class}{
\code{\link[biodb:ExtGenerator]{biodb::ExtGenerator}} -> \code{ExtMakefile}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ExtMakefile-new}{\code{ExtMakefile$new()}}
\item \href{#method-ExtMakefile-clone}{\code{ExtMakefile$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="biodb" data-topic="ExtGenerator" data-id="generate"><a href='../../biodb/html/ExtGenerator.html#method-ExtGenerator-generate'><code>biodb::ExtGenerator$generate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="biodb" data-topic="ExtGenerator" data-id="upgrade"><a href='../../biodb/html/ExtGenerator.html#method-ExtGenerator-upgrade'><code>biodb::ExtGenerator$upgrade()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtMakefile-new"></a>}}
\if{latex}{\out{\hypertarget{method-ExtMakefile-new}{}}}
\subsection{Method \code{new()}}{
Initializer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtMakefile$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{See the constructor of ExtGenerator for the parameters.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtMakefile-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ExtMakefile-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtMakefile$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
