% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExtTests.R
\name{ExtTests}
\alias{ExtTests}
\title{Extension tests class}
\description{
A class for generating test files.
}
\details{
This class generates a test file for running biodb generic tests, and a test
file containing an example of a custom test for this extension.
}
\examples{
# Generate a new package:
pkgFolder <- file.path(tempfile(), 'biodbFoo')
dir.create(pkgFolder, recursive=TRUE)
biodb::ExtTests$new(path=pkgFolder, dbName='foo.db', rcpp=TRUE,
                    remote=TRUE)$generate()

}
\section{Super class}{
\code{\link[biodb:ExtGenerator]{biodb::ExtGenerator}} -> \code{ExtTests}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ExtTests-new}{\code{ExtTests$new()}}
\item \href{#method-ExtTests-clone}{\code{ExtTests$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="biodb" data-topic="ExtGenerator" data-id="generate"><a href='../../biodb/html/ExtGenerator.html#method-ExtGenerator-generate'><code>biodb::ExtGenerator$generate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="biodb" data-topic="ExtGenerator" data-id="upgrade"><a href='../../biodb/html/ExtGenerator.html#method-ExtGenerator-upgrade'><code>biodb::ExtGenerator$upgrade()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtTests-new"></a>}}
\if{latex}{\out{\hypertarget{method-ExtTests-new}{}}}
\subsection{Method \code{new()}}{
Initializer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtTests$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{See the constructor of ExtGenerator for the parameters.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtTests-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ExtTests-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtTests$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
