% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExtVignette.R
\name{ExtVignette}
\alias{ExtVignette}
\title{Extension vignette class}
\description{
A class for generating a vignette example for an extension package.
}
\details{
This class generates a vignette file, serving as example to demonstrate the
use of the extension package.
}
\examples{
# Generate a new package:
pkgFolder <- file.path(tempfile(), 'biodbFoo')
dir.create(pkgFolder, recursive=TRUE)
biodb::ExtVignette$new(path=pkgFolder, dbName='foo.db',
                       dbTitle='Foo database', vignetteName='main', 
                       firstname='John', lastname='Smith',
                       remote=TRUE)$generate()

}
\section{Super classes}{
\code{\link[biodb:ExtGenerator]{biodb::ExtGenerator}} -> \code{\link[biodb:ExtFileGenerator]{biodb::ExtFileGenerator}} -> \code{ExtVignette}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ExtVignette-new}{\code{ExtVignette$new()}}
\item \href{#method-ExtVignette-clone}{\code{ExtVignette$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="biodb" data-topic="ExtGenerator" data-id="generate"><a href='../../biodb/html/ExtGenerator.html#method-ExtGenerator-generate'><code>biodb::ExtGenerator$generate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="biodb" data-topic="ExtGenerator" data-id="upgrade"><a href='../../biodb/html/ExtGenerator.html#method-ExtGenerator-upgrade'><code>biodb::ExtGenerator$upgrade()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtVignette-new"></a>}}
\if{latex}{\out{\hypertarget{method-ExtVignette-new}{}}}
\subsection{Method \code{new()}}{
Initializer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtVignette$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{See the constructor of ExtFileGenerator for the parameters.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtVignette-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ExtVignette-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtVignette$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
