% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RequestResult.R
\name{RequestResult}
\alias{RequestResult}
\title{Class RequestResult.}
\description{
Class RequestResult.

Class RequestResult.
}
\details{
Represents the result of a request.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RequestResult-new}{\code{RequestResult$new()}}
\item \href{#method-RequestResult-getContent}{\code{RequestResult$getContent()}}
\item \href{#method-RequestResult-getRetry}{\code{RequestResult$getRetry()}}
\item \href{#method-RequestResult-getErrMsg}{\code{RequestResult$getErrMsg()}}
\item \href{#method-RequestResult-getStatus}{\code{RequestResult$getStatus()}}
\item \href{#method-RequestResult-getRetryAfter}{\code{RequestResult$getRetryAfter()}}
\item \href{#method-RequestResult-getLocation}{\code{RequestResult$getLocation()}}
\item \href{#method-RequestResult-processRequestErrors}{\code{RequestResult$processRequestErrors()}}
\item \href{#method-RequestResult-clone}{\code{RequestResult$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RequestResult-new"></a>}}
\if{latex}{\out{\hypertarget{method-RequestResult-new}{}}}
\subsection{Method \code{new()}}{
New instance initializer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RequestResult$new(
  content = NULL,
  retry = FALSE,
  errMsg = NULL,
  status = 0,
  statusMessage = "",
  retryAfter = NULL,
  location = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{content}}{The result content.}

\item{\code{retry}}{If request should be resent.}

\item{\code{errMsg}}{Error message.}

\item{\code{status}}{HTTP status.}

\item{\code{statusMessage}}{Status message.}

\item{\code{retryAfter}}{Time after which to retry.}

\item{\code{location}}{New location.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RequestResult-getContent"></a>}}
\if{latex}{\out{\hypertarget{method-RequestResult-getContent}{}}}
\subsection{Method \code{getContent()}}{
Get content.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RequestResult$getContent()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The content as a character value or NULL.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RequestResult-getRetry"></a>}}
\if{latex}{\out{\hypertarget{method-RequestResult-getRetry}{}}}
\subsection{Method \code{getRetry()}}{
Get the retry flag.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RequestResult$getRetry()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
TRUE if the URL request should be sent again, FALSE otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RequestResult-getErrMsg"></a>}}
\if{latex}{\out{\hypertarget{method-RequestResult-getErrMsg}{}}}
\subsection{Method \code{getErrMsg()}}{
Get the error message.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RequestResult$getErrMsg()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The error message as a character value or NULL.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RequestResult-getStatus"></a>}}
\if{latex}{\out{\hypertarget{method-RequestResult-getStatus}{}}}
\subsection{Method \code{getStatus()}}{
Get the HTTP status of the response.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RequestResult$getStatus()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The status as an integer.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RequestResult-getRetryAfter"></a>}}
\if{latex}{\out{\hypertarget{method-RequestResult-getRetryAfter}{}}}
\subsection{Method \code{getRetryAfter()}}{
Get the time to wait before retrying.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RequestResult$getRetryAfter()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The time.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RequestResult-getLocation"></a>}}
\if{latex}{\out{\hypertarget{method-RequestResult-getLocation}{}}}
\subsection{Method \code{getLocation()}}{
Get the redirect location.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RequestResult$getLocation()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The redirect location as a character value or NULL.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RequestResult-processRequestErrors"></a>}}
\if{latex}{\out{\hypertarget{method-RequestResult-processRequestErrors}{}}}
\subsection{Method \code{processRequestErrors()}}{
Process possible HTTP error.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RequestResult$processRequestErrors()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RequestResult-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RequestResult-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RequestResult$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
