% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\docType{package}
\name{biodb-package}
\alias{biodb}
\alias{biodb-package}
\title{biodb: biodb, a library and a development framework for connecting to chemical and biological databases}
\description{
The biodb package provides access to standard remote chemical and biological databases (ChEBI, KEGG, HMDB, ...), as well as to in-house local database files (CSV, SQLite), with easy retrieval of entries, access to web services, search of compounds by mass and/or name, and mass spectra matching for LCMS and MSMS. Its architecture as a development framework facilitates the development of new database connectors for local projects or inside separate published packages.
}
\details{
To get a presentation of the \emph{biodb} package and get started with it, please
see the "biodb" vignette.

\if{html}{\out{<div class="sourceCode">}}\preformatted{vignette('biodb', package='biodb')
}\if{html}{\out{</div>}}
}
\seealso{
\link{BiodbMain}, \link{BiodbConfig}, \link{BiodbFactory},
\link{BiodbPersistentCache}, \link{BiodbDbsInfo}, \link{BiodbEntryFields}.
}
\author{
\strong{Maintainer}: Pierrick Roger \email{pierrick.roger@cea.fr} (\href{https://orcid.org/0000-0001-8177-4873}{ORCID})

Other contributors:
\itemize{
  \item Alexis Delabrière \email{delabriere@imsb.biol.ethz.ch} (\href{https://orcid.org/0000-0003-3308-4549}{ORCID}) [contributor]
}

}
