% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic_tests.R
\name{runGenericTests}
\alias{runGenericTests}
\title{Run generic tests.}
\usage{
runGenericTests(
  conn,
  pkgName,
  testRefFolder = NULL,
  opt = NULL,
  short = TRUE,
  long = FALSE,
  maxShortTestRefEntries = 1
)
}
\arguments{
\item{conn}{A valid biodb connector.}

\item{pkgName}{The name of your package.}

\item{testRefFolder}{The folder where to find test reference files.}

\item{opt}{A set of options to pass to the test functions.}

\item{short}{Run short tests.}

\item{long}{Run long tests.}

\item{maxShortTestRefEntries}{The maximum number of reference entries to use
in short tests.}
}
\value{
Nothing.
}
\description{
This function must be used in tests on all connector classes, before any
specific tests.
}
\examples{
# Instantiate a Biodb instance for testing
biodb <- biodb::createBiodbTestInstance()

# Create a connector instance
lcmsdb <- system.file("extdata", "massbank_extract.tsv", package="biodb")
conn <- biodb$getFactory()$createConn('mass.csv.file', lcmsdb)

# Run generic tests
\donttest{
biodb::runGenericTests(conn)
}

# Terminate the instance
biodb$terminate()

}
