% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiomics.R
\name{run_tf_integration}
\alias{run_tf_integration}
\title{Integration of expression and Transcription Factors / Generic Regulators}
\usage{
run_tf_integration(
  expression,
  tf_expression = expression,
  interactions = NULL,
  type = "none",
  sequencing_data = TRUE,
  species = "hsa",
  normalize = TRUE,
  norm_method = "TMM",
  normalize_cov = TRUE,
  norm_method_cov = "TMM",
  class = NULL,
  run_deg = TRUE,
  BPPARAM = SerialParam(),
  ...
)
}
\arguments{
\item{expression}{Matrix or data.frame containing the expression values
for each model. Rows represent samples, while each column represents
the different response variables of the models.}

\item{tf_expression}{Matrix or data.frame containing the expression
values for the models. Rows represent samples, while columns represent
the different covariates. If not provided, it will be set equal to
\strong{expression}.}

\item{interactions}{A list of character vectors containing the interactions
between response variable and covariates. The names of the list should
match the response variables while the character contained in each element
of the list should match the covariates. If NULL (default), the interactions
will be automatically downloaded according to the \strong{type} argument.}

\item{type}{A character defining the type of regulation under analysis.
Should be one of "tf_miRNA", "tf", "miRNA_target".}

\item{sequencing_data}{logical. Are expression data obtained from RNA
sequencing ? Default is set to TRUE}

\item{species}{species information for interactions download. Fully
supported species are "hsa" (default) and "mmu".}

\item{normalize}{logical.Should expression data be
normalized ? Default is set to TRUE}

\item{norm_method}{Normalization method to be used for
expression data. One of "TMM" (default), "TMMwsp", "RLE", "upperquartile",
"none".}

\item{normalize_cov}{Same as \strong{normalize} but for covariates.}

\item{norm_method_cov}{Same as \strong{norm_method} but for covariates.}

\item{class}{Character vector specifying the classes for differential
expression analysis.}

\item{run_deg}{Logical. Should differential expression analysis be performed?
Default is set to TRUE.}

\item{BPPARAM}{A BiocParallelParam object specifying the parallel backend to
be used.}

\item{...}{Additional arguments to be passed to internal functions.}
}
\value{
A list or a \linkS4class{MultiClass} object if \strong{class} is provided
containing the results of the transcriptional integration
}
\description{
This function will perform an integration of gene/miRNA expression data
and Transcription Factors expression. Moreover, every type of regulator can
be provided to the function as covariate through the \strong{tf_expression}
argument. Interactions for TF-target, miRNA-target and TF-miRNA integration
will be automatically downloaded by the function as defined by the \strong{type}
argument. Other types of interactions should be provided through the
\strong{interactions} argument.
}
\examples{
# Example usage_multi:
library(MultiAssayExperiment)
data("mmultiassay_ov")
tmp <- lapply(experiments(mmultiassay_ov), function(x) x[1:20,])
mmultiassay_ov <- MultiAssayExperiment(experiments = tmp)
gene_exp_matrix <- t(as.matrix(assay(mmultiassay_ov[["gene_exp"]])))
tf_integration <- run_tf_integration(expression = gene_exp_matrix, type="tf")
}
