% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allEndpoints.R
\name{get_result_sets}
\alias{get_result_sets}
\title{Retrieve all result sets matching the provided criteria}
\usage{
get_result_sets(
  datasets = NA_character_,
  resultSets = NA_character_,
  filter = NA_character_,
  offset = 0,
  limit = 20,
  sort = "+id",
  raw = getOption("gemma.raw", FALSE),
  memoised = getOption("gemma.memoised", FALSE),
  file = getOption("gemma.file", NA_character_),
  overwrite = getOption("gemma.overwrite", FALSE)
)
}
\arguments{
\item{datasets}{A vector of dataset IDs or short names}

\item{resultSets}{A resultSet identifier. Note that result set identifiers
are not static and can change when Gemma re-runs analyses internally. Whem
using these as inputs, try to make sure you access a currently existing
result set ID by basing them on result sets returned for a particular dataset or
filter used in \code{\link{get_result_sets}}}

\item{filter}{Filter results by matching expression. Use \code{\link{filter_properties}}
function to get a list of all available parameters. These properties can be
combined using "and" "or" clauses and may contain common operators such as "=", "<" or "in".
(e.g. "taxon.commonName = human", "taxon.commonName in (human,mouse), "id < 1000")}

\item{offset}{The offset of the first retrieved result.}

\item{limit}{Defaults to 20. Limits the result to specified amount
of objects. Has a maximum value of 100. Use together with \code{offset} and
the \code{totalElements} \link[base:attributes]{attribute} in the output to
compile all data if needed.}

\item{sort}{Order results by the given property and direction. The '+' sign
indicate ascending order whereas the '-' indicate descending.}

\item{raw}{\code{TRUE} to receive results as-is from Gemma, or \code{FALSE} to enable
parsing. Raw results usually contain additional fields and flags that are
omitted in the parsed results.}

\item{memoised}{Whether or not to save to cache for future calls with the
same inputs and use the result saved in cache if a result is already saved.
Doing \code{options(gemma.memoised = TRUE)} will ensure that the cache is always
used. Use \code{\link{forget_gemma_memoised}} to clear the cache.}

\item{file}{The name of a file to save the results to, or \code{NULL} to not write
results to a file. If \code{raw == TRUE}, the output will be the raw endpoint from the
API, likely a JSON or a gzip file. Otherwise, it will be a RDS file.}

\item{overwrite}{Whether or not to overwrite if a file exists at the specified
filename.}
}
\value{
A data table with information about the queried result sets. Note that this function does not return
differential expression values themselves. Use \code{\link{get_differential_expression_values}}
to get differential expression values

\itemize{
\item \code{result.ID}: Result set ID of the differential expression analysis.
May represent multiple factors in a single model.
\item \code{contrast.ID}: Id of the specific contrast factor. Together with the result.ID
they uniquely represent a given contrast.
\item \code{experiment.ID}: Id of the source experiment
\item \code{factor.category}: Category for the contrast
\item \code{factor.category.URI}: URI for the contrast category
\item \code{factor.ID}: ID of the factor
\item \code{baseline.factors}: Characteristics of the baseline. This field is a data.table
\item \code{experimental.factors}: Characteristics of the experimental group. This field is a data.table
\item \code{isSubset}: TRUE if the result set belong to a subset, FALSE if not. Subsets are created when performing differential expression to avoid unhelpful comparisons.
\item \code{subsetFactor}: Characteristics of the subset. This field is a data.table
}
}
\description{
Returns queried result set
}
\details{
Output and usage of this function is mostly identical to \code{\link{get_dataset_differential_expression_analyses}}.
The principal difference being the ability to restrict your result sets, being able to
query across multiple datasets and being able to use the filter argument
to search based on result set properties.
}
\examples{
get_result_sets(dataset = 1)
# get all contrasts comparing disease states. use filter_properties to see avaialble options
get_result_sets(filter = "baselineGroup.characteristics.value = disease")
}
\keyword{misc}
