% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processors.R
\name{processPlatforms}
\alias{processPlatforms}
\title{Processes JSON as a vector of platforms}
\usage{
processPlatforms(d)
}
\arguments{
\item{d}{The JSON to process}
}
\value{
A data table with information about the platform(s). A list if \code{raw = TRUE}. A \code{404 error} if the given identifier
does not map to any object

The fields of the output data.table are:
\itemize{
\item \code{platform.ID}: Internal identifier of the platform
\item \code{platform.shortName}: Shortname of the platform.
\item \code{platform.name}: Full name of the platform.
\item \code{platform.description}: Free text description of the platform
\item \code{platform.troubled}: Whether or not the platform was marked "troubled" by a Gemma process or a curator
\item \code{platform.experimentCount}: Number of experiments using the platform within Gemma
\item \code{platform.type}: Technology type for the platform.
\item \code{taxon.name}: Name of the species platform was made for
\item \code{taxon.scientific}: Scientific name for the taxon
\item \code{taxon.ID}: Internal identifier given to the species by Gemma
\item \code{taxon.NCBI}: NCBI ID of the taxon
\item \code{taxon.database.name}: Underlying database used in Gemma for the taxon
\item \code{taxon.database.ID}: ID of the underyling database used in Gemma for the taxon
}
}
\description{
Processes JSON as a vector of platforms
}
\keyword{internal}
