% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createTADGeometries.R
\name{createTADGeometries}
\alias{createTADGeometries}
\title{create 3d Geometry by given TADs}
\usage{
createTADGeometries(
  tad,
  targetObj,
  type = "sphere",
  name = "TAD_",
  tag = "TAD",
  alpha = 0.2,
  lwd = 3
)
}
\arguments{
\item{tad}{The TAD. An object of
\link[GenomicRanges:GRanges-class]{GRanges}.}

\item{targetObj}{The GRanges object with mcols x0, y0, z0, x1, y1, and z1}

\item{type}{The Geometry type. default is sphere. Possible types are
sphere or segment.}

\item{name}{The prefix for the name of the geometries.}

\item{tag}{The tag used to group geometries.}

\item{alpha}{alpha value. default is 0.2}

\item{lwd}{line width for segment.}
}
\value{
\link{threeJsGeometry} objects
}
\description{
Create a 3d Geometry by given TADs for target 3d positions.
}
\examples{
library(GenomicRanges)
obj <- readRDS(system.file("extdata", "4DNFI1UEG1HD.chr21.FLAMINGO.res.rds",
  package = "geomeTriD"
))
tjg <- view3dStructure(obj, renderer = "none")
pc <- pointCluster(as.data.frame(mcols(obj)))
tads <- split(obj, pc$cluster)
tads <- tads[names(tads)!="0"] # cluster 0 is noise
tads <- unlist(range(GRangesList(tads)))
backbone <- extractBackbonePositions(tjg)
tad_geometries <- createTADGeometries(tads, backbone)
threeJsViewer(tjg, tad_geometries)
}
