% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFeatureQC.R
\name{plotFeatureQC}
\alias{plotFeatureQC}
\title{plotFeatureQC}
\usage{
plotFeatureQC(
  spe,
  plot_type = c("histogram", "violin"),
  x_metric = NULL,
  annotate = NULL,
  n_bins = 100,
  point_size = 0.1,
  scale_log1p = TRUE
)
}
\arguments{
\item{spe}{Input data, assumed to be a \code{SpatialExperiment} or
\code{SingleCellExperiment} object.}

\item{plot_type}{Type of QC plot. Options are "histogram" and "violin". See
Details for additional details.}

\item{x_metric}{Name of column in \code{rowData} containing feature-level QC
metric to plot on x-axis. Required for histograms and violin plots.}

\item{annotate}{Name of column in \code{rowData} identifying selected
features that do not meet QC filtering thresholds, which will be
highlighted on a histogram or violin plot. Default = NULL. Optional
argument used for histograms and violin plots.}

\item{n_bins}{Number of bins for histograms. Default = 100. Optional argument
used for histograms.}

\item{point_size}{Point size. Default = 0.1. Optional argument for violin
plots.}

\item{scale_log1p}{Whether to log1p-scale axes. Default = TRUE.}
}
\value{
Returns a ggplot object, which may be further modified using ggplot
  functions.
}
\description{
Plotting functions for spatial transcriptomics data.
}
\details{
Function to create quality control (QC) plots for spatial transcriptomics
data.

The following types of QC plots are available for feature-level QC (see
\code{\link{plotSpotQC}} for spot-level or cell-level QC):

\itemize{
\item Histogram (\code{plot_type = "histogram"}) for a single QC metric, e.g.
total UMI counts across all spots per feature. The histogram can optionally
highlight selected features, e.g. low abundance features.
\item Violin (\code{plot_type = "violin"}) for a single QC metric, e.g. total
UMI counts across all spots per feature. The violin plot can optionally
highlight selected features, e.g. low abundance features.
}
}
\examples{
library(STexampleData)
spe <- Visium_humanDLPFC()

rowData(spe)$feature_sum <- rowSums(counts(spe))
rowData(spe)$low_abundance <- rowSums(counts(spe) > 0) < 20

plotFeatureQC(spe, plot_type = "histogram", 
              x_metric = "feature_sum", annotate = "low_abundance")
plotFeatureQC(spe, plot_type = "violin", 
              x_metric = "feature_sum", annotate = "low_abundance")

}
\author{
Yixing E. Dong and Lukas M. Weber
}
