% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotVisium.R
\name{plotVisium}
\alias{plotVisium}
\title{plotVisium}
\usage{
plotVisium(
  spe,
  spots = TRUE,
  annotate = NULL,
  highlight = NULL,
  facets = "sample_id",
  image = TRUE,
  zoom = FALSE,
  show_axes = FALSE,
  assay = "counts",
  trans = "identity",
  point_size = 1,
  legend_position = "right",
  x_coord = NULL,
  y_coord = NULL,
  y_reverse = TRUE,
  sample_ids = NULL,
  image_ids = NULL,
  pal = NULL
)
}
\arguments{
\item{spe}{(SpatialExperiment) Input data object.}

\item{spots}{(logical) Whether to display spots (spatial barcodes) as points.
Default = TRUE.}

\item{annotate}{(character) Column in \code{colData} to use to fill points by
color. If \code{annotate} contains a numeric column (e.g. total UMI counts), a
continuous color scale will be used. If \code{annotate} contains a factor (e.g.
cluster labels), a discrete color scale will be used. Default = NULL.}

\item{highlight}{(character) Column in \code{colData} to use to highlight
points by outlining them. For example, \code{in_tissue} will highlight
spots overlapping with tissue. Default = NULL.}

\item{facets}{(character) Column in \code{colData} to use to facet plots,
i.e. show multiple panels of plots. Default = "sample_id". Set to NULL to
disable.}

\item{image}{(logical) Whether to show histology image as background. Default
= TRUE.}

\item{zoom}{(logical) Whether to zoom to area of tissue containing spots.
Default = FALSE}

\item{show_axes}{(logical) Whether to show axes and coordinates. Default =
FALSE}

\item{assay}{(character) Name of assay data to use when \code{annotate} is in
\code{rownames(spe)}. Should be one of \code{assayNames(spe)}.}

\item{trans}{Transformation to apply for continuous scales. Ignored unless
\code{annotate} is numeric, e.g. feature expression. (See
\code{\link{ggplot2}{continuous_scale}} for valid options.)}

\item{point_size}{(numeric) Point size. Default = 1.}

\item{legend_position}{Legend position for annotations. Options are "left",
"right", "top", "bottom", and "none". Default = "right".}

\item{x_coord}{(character) Column in \code{spatialCoords} containing
x-coordinates. Default = NULL, which selects the first column.}

\item{y_coord}{(character) Column in \code{spatialCoords} containing
y-coordinates. Default = NULL, which selects the second column.}

\item{y_reverse}{(logical) Whether to reverse y coordinates, which is often 
required for Visium data, depending on the orientation of the raw data.
Default = TRUE.}

\item{sample_ids}{(character) Samples to show, if multiple samples are
available. Default = NULL (show all samples).}

\item{image_ids}{(character) Images to show, if multiple images are
available. Default = NULL (show all images).}

\item{pal}{(character) Color palette for points. Options for discrete
labels are "libd_layer_colors", "Okabe-Ito", or a custom vector of hex
color codes. Options for continuous values are "viridis", a single color
name (e.g. "red", "navy", etc), or a vector of length two containing color
names for each end of the scale. Default = "libd_layer_colors" for discrete
data, and "viridis" for continuous data.}
}
\value{
Returns a ggplot object. Additional plot elements can be added as
  ggplot elements (e.g. title, customized formatting, etc).
}
\description{
Plots for spatially resolved transcriptomics data from the 10x Genomics
Visium platform
}
\details{
Function to generate plots for spatially resolved transcriptomics datasets
from the 10x Genomics Visium spatially platform.

This function generates a plot for spot-based spatially resolved
transcriptomics data from the 10x Genomics Visium platform, with several
options available to adjust the plot type and style.
}
\examples{
library(STexampleData)

spe <- Visium_mouseCoronal()

# color by x coordinate, highlight in-tissue spots
plotVisium(spe, annotate = "pxl_col_in_fullres", highlight = "in_tissue")

# subset in-tissue spots
sub <- spe[, as.logical(colData(spe)$in_tissue)]

# color by feature counts, don't include image
rownames(sub) <- make.names(rowData(sub)$gene_name)
plotVisium(sub, annotate = "Gad2", assay = "counts")

}
\author{
Helena L. Crowell, with modifications by Lukas M. Weber and Yixing E.
  Dong
}
