% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmpScreePlot.R
\name{lmpScreePlot}
\alias{lmpScreePlot}
\title{Scree Plot}
\usage{
lmpScreePlot(
  resLmpContributions,
  effectNames = NULL,
  nPC = 5,
  theme = theme_bw()
)
}
\arguments{
\item{resLmpContributions}{A resLmpContributions list from the function \code{\link{lmpContributions}}.}

\item{effectNames}{Names of the effects to be plotted. if \code{NULL}, all the effects are plotted.}

\item{nPC}{An integer with the number of components to plot.}

\item{theme}{\code{ggplot} theme}
}
\value{
A scree plot (ggplot).
}
\description{
Provides a barplot of the percentage of variance associated to the PCs of the effect matrices ordered by importance based on the outputs of \code{\link{lmpContributions}}.
}
\examples{

data("UCH")
resLmpModelMatrix <- lmpModelMatrix(UCH)
resLmpEffectMatrices <- lmpEffectMatrices(resLmpModelMatrix)
resASCAE <- lmpPcaEffects(resLmpEffectMatrices, method = "ASCA-E")
resLmpContributions <- lmpContributions(resASCAE)
lmpScreePlot(resLmpContributions, effectNames = "Hippurate:Citrate", nPC = 4)

}
