% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotScatterM.R
\name{plotScatterM}
\alias{plotScatterM}
\title{Scatter plot matrix}
\usage{
plotScatterM(
  Y = NULL,
  design = NULL,
  lmpDataList = NULL,
  cols,
  labelVector = NULL,
  title = "Scatterplot matrix",
  varname.colorup = NULL,
  varname.colordown = NULL,
  varname.pchup = NULL,
  varname.pchdown = NULL,
  vec.colorup = NULL,
  vec.colordown = NULL,
  vec.pchup = NULL,
  vec.pchdown = NULL
)
}
\arguments{
\item{Y}{\eqn{n \times m} matrix with \eqn{n} observations and \eqn{m} variables. Can be \code{NULL} if \code{lmpDataList} is defined.}

\item{design}{A \eqn{n \times k} "freely encoded" experimental design data.frame. Can be \code{NULL} if \code{lmpDataList} is defined.}

\item{lmpDataList}{If not \code{NULL}, a list with outcomes, design and formula, as outputted by \code{\link{data2LmpDataList}}.}

\item{cols}{A vector with either the column names of the \eqn{Y} matrix to plot (character) or the column index positions.}

\item{labelVector}{Labels to display on the diagonal. If \code{NULL}, the column names are deduced from \code{cols}.}

\item{title}{Title of the graph.}

\item{varname.colorup}{A character string with the name of the variable used to color the upper triangle.}

\item{varname.colordown}{A character string with the name of the variable used to color the lower triangle.}

\item{varname.pchup}{A character string with the name of the variable used to mark points for the upper triangle.}

\item{varname.pchdown}{A character string with the name of the variable used to mark points for the lower triangle.}

\item{vec.colorup}{A color vector (character or numeric) with a length equal to the number of levels of \code{varname.colorup}.}

\item{vec.colordown}{A color vector (character or numeric) with a length equal to the number of levels of \code{varname.colordown}.}

\item{vec.pchup}{A symbol vector (character or numeric) with a length equal to the number of levels of \code{varname.pchup}.}

\item{vec.pchdown}{A symbol vector (character or numeric) with a length equal to the number of levels of \code{varname.pchdown}.}
}
\value{
A matrix of scatter plots.
}
\description{
Produces a scatter plot matrix between the selected columns of the outcomes matrix \eqn{Y} choosing specific colors and symbols for up to four factors from the design on the upper and lower diagonals.
}
\details{
Either \code{Y} or \code{lmpDataList} need to be defined. If both are given, the priority goes to \code{Y}.
The same rule applies for \code{design} or \code{lmpDataList}.
}
\examples{

data("UCH")

# basic usage
plotScatterM(
  Y = UCH$outcomes, design = UCH$design, cols = c(1:4)
)

# equivalent to:
plotScatterM(
  lmpDataList = UCH, cols = c(1:4)
)

# with optionnal arguments
plotScatterM(
  Y = UCH$outcomes, design = UCH$design, cols = c(1:4),
  varname.colorup = "Hippurate", varname.colordown = "Citrate",
  varname.pchup = "Time", varname.pchdown = "Day",
  vec.colorup = c(2, 4, 1),
  vec.colordown = c("orange", "purple", "green"),
  vec.pchup = c(1, 2), vec.pchdown = c("a", "b")
)

}
