% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylInheritanceInternalMethods.R
\name{runOnePermutationOnAllGenerations}
\alias{runOnePermutationOnAllGenerations}
\title{Run the analysis on one permutation dataset, including all
generations, using \code{methylKit} package}
\usage{
runOnePermutationOnAllGenerations(
  id,
  methylInfoForAllGenerations,
  type = c("both", "sites", "tiles"),
  outputDir = NULL,
  nbrCoresDiffMeth = 1,
  minReads = 10,
  minMethDiff = 10,
  qvalue = 0.01,
  maxPercReads = 99.9,
  destrand = FALSE,
  minCovBasesForTiles = 0,
  tileSize = 1000,
  stepSize = 1000,
  restartCalculation,
  saveInfoByGeneration
)
}
\arguments{
\item{id}{an \code{integer}, the unique identification of the permutation.
When \code{id} is \code{0}, the analysis is done on the real dataset.}

\item{methylInfoForAllGenerations}{a \code{list} of \code{methylRawList}
entries. Each
\code{methylRawList} entry must contain all the \code{methylRaw} entries
related to one generation (first entry = first generation, second
entry = second generation, etc..). The number of generations must
correspond to the number
of entries in the \code{methylKitData}. At least 2 generations
must be present to make a permutation analysis. More information can be
found in the methylKit package.}

\item{type}{One of the "sites","tiles" or "both" strings. Specifies the type
of differentially methylated elements should be returned. For
retrieving differentially methylated bases type="sites"; for
differentially methylated regions type="tiles". Default: "both".}

\item{outputDir}{a string, the name of the directory that will contain
the results of the permutation. If the directory does not
exist, it will be created.}

\item{nbrCoresDiffMeth}{a positive integer, the number of cores to use for
parallel differential methylation calculations.Parameter used for both
sites and tiles analysis. The parameter
corresponds to the \code{num.cores} parameter in the
package \code{methylKit}.
Default: \code{1} and always \code{1} for Windows.}

\item{minReads}{a positive \code{integer} Bases and regions having lower
coverage than this count are discarded. The parameter
correspond to the \code{lo.count} parameter in the  \code{methylKit} package.}

\item{minMethDiff}{a positive integer betwwen [0,100], the absolute value
of methylation percentage change between cases and controls. The parameter
correspond to the \code{difference} parameter in the
package \code{methylKit}. Default: \code{10}.}

\item{qvalue}{a positive \code{double} inferior to \code{1}, the cutoff
for qvalue of differential methylation statistic. Default: \code{0.01}.}

\item{maxPercReads}{a double between [0-100], the percentile of read
counts that is going to be used as upper cutoff. Bases ore regions
having higher
coverage than this percentile are discarded. Parameter used for both CpG
sites and tiles analysis. The parameter
correspond to the \code{hi.perc} parameter in the  \code{methylKit} package.
Default: \code{99.9}.}

\item{destrand}{a logical, when \code{TRUE} will merge reads on both
strands of a CpG dinucleotide to provide better coverage. Only advised
when looking at CpG methylation. Parameter used for both
sites and tiles analysis. Default: \code{FALSE}.}

\item{minCovBasesForTiles}{a non-negative integer, the minimum number of
bases to be covered in a given tiling window. The parameter
corresponds to the \code{cov.bases} parameter in the
package \code{methylKit}.
Only used when \code{doingTiles} =
\code{TRUE}. Default: \code{0}.}

\item{tileSize}{a positive integer, the size of the tiling window. The
parameter corresponds to the \code{win.size} parameter in
the  \code{methylKit} package. Only
used when \code{doingTiles} = \code{TRUE}. Default: \code{1000}.}

\item{stepSize}{a positive integer, the step size of tiling windows. The
parameter corresponds to the \code{stepSize} parameter in
the  \code{methylKit} package. Only
used when \code{doingTiles} = \code{TRUE}. Default: \code{1000}.}

\item{restartCalculation}{a \code{logical}, when \code{TRUE}, only
permutations that don't have a RDS result final are run.}

\item{saveInfoByGeneration}{a \code{logical}, when \code{TRUE}, the
information about differentially methylated sites and tiles for each
generation is saved in a RDS file. The information is saved in a different
file for each permutation. The files are = saved in the
\code{outputDir}.}
}
\value{
a \code{list} containing the following elements:
\itemize{
\item \code{SITES} Only present when \code{type} = \code{"sites"} or
\code{"both"}, a \code{list} containing:
\itemize{
\item\code{i2} a \code{list} containing:
\itemize{
\item \code{HYPER} a \code{list} of \code{integer}, the number of conserved
hyper differentially methylated sites between two consecutive generations.
The first element represents the intersection of the first and second
generations; the second element, the intersection of the second and third
generations; etc..
\item \code{HYPO} a \code{list} of \code{integer}, the number of conserved
hypo differentially methylated sites between two consecutive generations.The
first element represents the intersection of the first and second
generations; the second element, the intersection of the second and third
generations; etc..
}
\item\code{iAll} a \code{list} containing:
\itemize{
\item \code{HYPER} a \code{list} of \code{integer}, the number of conserved
hyper differentially methylated sites between three or more consecutive
generations. The first element represents the intersection of the first
three generations; the second element, the intersection of the first fourth
generations; etc..The number of entries depends of the number
of generations.
\item \code{HYPO} a \code{list} of \code{integer}, the number of conserved
hypo differentially methylated sites between three or more consecutive
generations. The first element represents the intersection of the first
three generations; the second element, the intersection of the first fourth
generations; etc..The number of entries depends of the number of
generations.
}
}
\item \code{TILES} Only present when \code{type} = \code{"tiles"} or
\code{"both"}, a \code{list} containing:
itemize{
\item\code{i2} a \code{list} containing:
\itemize{
\item \code{HYPER} a \code{list} of \code{integer}, the number of conserved
hyper differentially methylated positions between two consecutive
generations. The first element represents the intersection of the
first and second generations; the second element, the intersection of
the second and third generations; etc..
\item \code{HYPO} a \code{list} of \code{integer}, the number of conserved
hypo differentially methylated positions between two consecutive
generations.The first element represents the intersection of the first and
second generations; the second element, the intersection of the second
and third generations; etc..
}
\item\code{iAll} a \code{list} containing:
\itemize{
\item \code{HYPER} a \code{list} of \code{integer}, the number of conserved
hyper differentially methylated positions between three or more consecutive
generations. The first element represents the intersection of the first
three generations; the second element, the intersection of the first fourth
generations; etc..The number of entries depends of the number
of generations.
\item \code{HYPO} a \code{list} of \code{integer}, the number of conserved
hypo differentially methylated positions between three or more consecutive
generations. The first element represents the intersection of the first
three generations; the second element, the intersection of the first fourth
generations; etc..The number of entries depends of the number of
generations.
}
}
}
}
\description{
Run CpG site or region analysis using the \code{methylKit}
package for each generation present in the dataset. The intersection of
conserved elements is obtained for each group of two consecutive
generations, as well as, for larger group subset. The output of the
analysis is saved in a RDS file when an directory is
specified.
}
\examples{

## Load methyl information
data(samplesForTransgenerationalAnalysis)

## Run a permutation analysis
methylInheritance:::runOnePermutationOnAllGenerations(id = 2,
    methylInfoForAllGenerations = samplesForTransgenerationalAnalysis,
    type = "tiles", outputDir = NULL,
    nbrCoresDiffMeth = 1, minReads = 10, minMethDiff = 10, qvalue = 0.01,
    maxPercReads = 99.9, destrand = FALSE, minCovBasesForTiles = 0,
    tileSize = 1000, stepSize = 1000, restartCalculation = FALSE)

}
\author{
Astrid Deschenes, Pascal Belleau
}
\keyword{internal}
