% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylInheritance.R
\docType{data}
\name{samplesForTransgenerationalAnalysis}
\alias{samplesForTransgenerationalAnalysis}
\title{All samples information, formated by \code{methylKit}, in a
\code{methylRawList} format (for demo purpose).}
\format{
A \code{list} containing three \code{methylRawList} objects. Each
\code{methylRawList} contains the information for one generation
(first entry = first generation, etc..). Each sample information is
stored in a \code{methylRaw} object. There is \code{methylRaw} objects
(6 controls and 6 cases) in each generation.
}
\usage{
data(samplesForTransgenerationalAnalysis)
}
\value{
A \code{list} containing three \code{methylRawList} objects. Each
\code{methylRawList} contains the information for one generation
(first entry = first generation, etc..). Each sample information is
stored in a \code{methylRaw} object. There is \code{methylRaw} objects
(6 controls and 6 cases) in each generation.
}
\description{
The object is a \code{list} with 3 entries. Each entry corresponds to the
information for one generation (first entry = first generation, etc..)
stored in a \code{methylRawList}.
There are 12 samples (6 controls and 6 cases) for each generation. Each
sample information is stored in a \code{methylRaw} object.
}
\details{
This dataset can be
used to test the \code{runPermutation} function.
}
\examples{

## Loading dataset
data(samplesForTransgenerationalAnalysis)

## Run a permutation analysis
runPermutation(methylKitData = samplesForTransgenerationalAnalysis,
    type = "tiles", nbrPermutations = 2, vSeed = 2332)

}
\seealso{
\itemize{
    \item \code{\link{runPermutation}} {for running a
    permutation analysis, and optionally an observation analysis, using
    multi-generational dataset}
}
}
\keyword{datasets}
