% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylInheritanceInternalMethods.R
\name{saveInterGenerationResults}
\alias{saveInterGenerationResults}
\title{Save the result of on CpG site or tile analysis on all generations.
The anaysis can come from observed or shuffled dataset. Each case is
saved with a different extension.}
\usage{
saveInterGenerationResults(
  outputDir,
  permutationID,
  type = c("sites", "tiles"),
  interGenerationResult
)
}
\arguments{
\item{outputDir}{a string of \code{character}, the name of the directory
that will contain
the results of the permutation. The name should end with a slash. The
directory should already exists.}

\item{permutationID}{an \code{integer}, the identifiant of the permutation.
When the \code{permutationID} = \code{0}, the results are considered as the
observed results and are saved in a file with the "_observed_results.RDS"
extension. When the \code{permutationID} != \code{0}, the results are
considered as permutation results and are saved in a file with the
"_permutation_{permutationID}.RDS" extension.}

\item{type}{One of the \code{"sites"} or \code{"tiles"} strings. Specifies
the type of differentially methylated elements should be saved.
Default: \code{"sites"}.}

\item{interGenerationResult}{a \code{list} that corresponds to the output
of the \code{interGeneration} function, the result of on CpG site or tile
analysis on all generations.}
}
\value{
\code{0} indicating that all parameters validations have been
successful.
}
\description{
Save the result of on CpG site or tile analysis on all
generations. The results are saved in a RDS file. The anaysis can have been
done on the observed or shuffled dataset.
Each permutation is saved using its identifiant in the file name.
}
\examples{

## Load permutation results on sites

permutationResultsFile <- system.file("extdata",
    "permutationResultsForSites.RDS", package="methylInheritance")
permutationResults <- readRDS(permutationResultsFile)

## Transform result to GRanges
resultsGR <- methylInheritance:::getGRangesFromMethylDiff(methDiff =
    permutationResults, pDiff = 10, qvalue = 0.01, type = "hyper")

## Extract inter-generationally conserved sites
interGenerationResult <- methylInheritance:::interGeneration(resultsGR)

## Create directories
dir.create("TEST", showWarnings = TRUE)
dir.create("TEST/SITES", showWarnings = TRUE)

## Save results
methylInheritance:::saveInterGenerationResults(
    outputDir = "TEST/", permutationID=100, type = "sites",
    interGenerationResult = interGenerationResult)

}
\author{
Astrid Deschenes, Pascal Belleau
}
\keyword{internal}
