% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_silhouettes.R
\name{get_silhouettes}
\alias{get_silhouettes}
\title{Get silhouettes}
\source{
\href{https://github.com/GuangchuangYu/ggimage/blob/master/R/geom_phylopic.R}{
Related function: \code{ggimage::geom_phylopic}}

\href{https://github.com/palaeoverse-community/rphylopic/issues/39}{
phylopic/rphylopic API changes}

\href{https://github.com/GuangchuangYu/ggimage/issues/40}{
ggimage: Issue with finding valid PNGs}
}
\usage{
get_silhouettes(
  species,
  which = rep(1, length(species)),
  run_format_species = TRUE,
  include_image_data = FALSE,
  mc.cores = 1,
  add_png = FALSE,
  remove_bg = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{species}{A character vector of species names 
to query \href{phylopic.org}{phylopic} for.}

\item{which}{An integer vector of the same length as \code{species}. 
Lets you choose which image you want to use for each species 
(1st, 2nd 3rd, etc.).}

\item{run_format_species}{Standardise species names with 
\link[orthogene]{format_species} before querying 
\href{phylopic.org}{phylopic} (default: \code{TRUE}).}

\item{include_image_data}{Include the image data itself 
(not just the image UID) in the results.}

\item{mc.cores}{Accelerate multiple species queries by parallelising 
across multiple cores.}

\item{add_png}{Return URLs for both the SVG and PNG versions of the image.}

\item{remove_bg}{Remove image background.}

\item{verbose}{Print messages.}
}
\value{
data.frame with:
\itemize{
\item{input_species : }{Species name (input).}
\item{species : }{Species name (standardised).}
\item{uid : }{Species UID.} 
\item{url : }{Image URL.} 
}
}
\description{
Get silhouette images of each species from \href{phylopic.org}{phylopic}.
}
\examples{
 
species <- c("Mus_musculus","Pan_troglodytes","Homo_sapiens")
uids <- get_silhouettes(species = species)
}
