% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infer_species.R
\name{infer_species}
\alias{infer_species}
\title{Infer species from gene names}
\usage{
infer_species(
  gene_df,
  gene_input = "rownames",
  test_species = c("human", "monkey", "rat", "mouse", "zebrafish", "fly"),
  method = c("homologene", "gprofiler", "babelgene"),
  make_plot = TRUE,
  show_plot = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{gene_df}{Data object containing the genes
(see \code{gene_input} for options on how
the genes can be stored within the object).\cr
Can be one of the following formats:\cr
\itemize{
\item{\code{matrix} : \cr}{A sparse or dense matrix.}
\item{\code{data.frame} : \cr}{A \code{data.frame},
 \code{data.table}. or \code{tibble}.}
\item{code{list} : \cr}{A \code{list} or character \code{vector}.}
}
Genes, transcripts, proteins, SNPs, or genomic ranges
 can be provided in any format
(HGNC, Ensembl, RefSeq, UniProt, etc.) and will be
automatically converted to gene symbols unless
specified otherwise with the \code{...} arguments.\cr
\emph{Note}: If you set \code{method="homologene"}, you
must either supply genes in gene symbol format (e.g. "Sox2")
 OR set \code{standardise_genes=TRUE}.}

\item{gene_input}{Which aspect of \code{gene_df} to
get gene names from:\cr
\itemize{
\item{\code{"rownames"} : \cr}{From row names of data.frame/matrix.}
\item{\code{"colnames"} : \cr}{From column names of data.frame/matrix.}
\item{\code{<column name>} : \cr}{From a column in \code{gene_df},
 e.g. \code{"gene_names"}.}
}}

\item{test_species}{Which species to test for matches with.
If set to \code{NULL}, will default to a list of humans and
 5 common model organisms.
 If \code{test_species} is set to one of the following options, 
 it will automatically pull all species from that respective package and 
 test against each of them:  
 \itemize{
 \item{"homologene" : }{20+ species (default)}
 \item{"gprofiler" : }{700+ species}
 \item{"babelgene" : }{19 species}
 }}

\item{method}{R package to use for gene mapping:
\itemize{
\item{\code{"gprofiler"} : Slower but more species and genes.}
\item{\code{"homologene"} : Faster but fewer species and genes.}
\item{\code{"babelgene"} : Faster but fewer species and genes.
Also gives consensus scores for each gene mapping based on a
 several different data sources.}
}}

\item{make_plot}{Make a plot of the results.}

\item{show_plot}{Print the plot of the results.}

\item{verbose}{Print messages.}
}
\value{
An ordered dataframe of \code{test_species} 
from best to worst matches.
}
\description{
Infers which species the genes within \code{gene_df} is from.
Iteratively test the percentage of \code{gene_df} genes that match with 
the genes from each \code{test_species}.
}
\examples{
 
data("exp_mouse") 
matches <- orthogene::infer_species(gene_df = exp_mouse[1:200,])
}
