% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createFunctionsList.R
\name{createFunctionsList}
\alias{createFunctionsList}
\title{Create Functions List}
\usage{
createFunctionsList(FUN, param.name, values, func.names)
}
\arguments{
\item{FUN}{Function. the function to be partially applied}

\item{param.name}{Character. The name of the parameter to pre-set.}

\item{values}{A list or vector of values to preassign. A function will be created for each of the values in values. If present, the names of the list will be the names of the functions.}

\item{func.names}{Character. The names of the functions created. Useful to identify the functions created. Defaults to the names of the values list or to Function1, Function2... if the values list has no names.}
}
\value{
It returns a list of functions with parameter param.value pre-set to values.
}
\description{
Partially applies (the standard Curry function in functional programming) a list of arguments
to a function and returns a list of preapplied functions. The result of this function is a
list of functions suitable for the multiple evaluation functions in permTest.
}
\note{
It uses the code posted by "hadley" at http://stackoverflow.com/questions/6547219/how-to-bind-function-arguments
}
\examples{
f <- function(a, b) {
 return(a+b)
}

funcs <- createFunctionsList(FUN=f, param.name="b", values=c(1,2,3), func.names=c("plusone", "plustwo", "plusthree"))

funcs$plusone(2)
funcs$plusone(10)
funcs$plusthree(2)

A <- createRandomRegions(nregions=20, length.mean=10000000, length.sd=0, mask=NA)
B <- createRandomRegions(nregions=20, length.mean=10000000, length.sd=0, mask=NA)

 overlapsWith <- createFunctionsList(FUN=numOverlaps, param.name="B", values=list(a=A, b=B))
 overlapsWith$a(A=A) 
 overlapsWith$b(A=A) 

}
\seealso{
\code{\link{permTest}}, \code{\link{overlapPermTest}}
}
