% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meanDistance.R
\name{meanDistance}
\alias{meanDistance}
\title{Mean Distance}
\usage{
meanDistance(A, B, ...)
}
\arguments{
\item{A}{a region set in any of the accepted formats by \code{\link{toGRanges}} (\code{\link{GenomicRanges}}, \code{\link{data.frame}}, etc...)}

\item{B}{a region set in any of the accepted formats by \code{\link{toGRanges}} (\code{\link{GenomicRanges}}, \code{\link{data.frame}}, etc...)}

\item{...}{any additional parameter needed}
}
\value{
The mean of the distances of each region in A to the nearest region in B.
}
\description{
Computes the mean distance of regions in A to the nearest element in B
}
\note{
If a region in A is in a chromosome where no B region is, it will be ignored and removed from the mean computation.
}
\examples{
A <- data.frame("chr1", c(1, 10, 20, 30), c(12, 13, 28, 40))

B <- data.frame("chr1", 25, 35)

meanDistance(A, B)

}
