% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recomputePermTest.R
\name{recomputePermTest}
\alias{recomputePermTest}
\title{Recompute Permutation Test}
\usage{
recomputePermTest(ptr)
}
\arguments{
\item{ptr}{an object of class \code{permTestResults}}
}
\value{
A list of class \code{permTestResults} containing the same components as \code{\link{permTest}} results.
}
\description{
Recomputes the permutation test changing the alternative hypotesis
}
\examples{
A <- createRandomRegions(nregions=10, length.mean=1000000)

B <- createRandomRegions(nregions=10, length.mean=1000000)

resPerm <- permTest(A=A, B=B, ntimes=5, alternative="less", genome="hg19", evaluate.function=meanDistance, randomize.function=randomizeRegions)

plot(resPerm)



 
}
\seealso{
\code{\link{permTest}}
}
